/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class MessagingSticker
implements Serializable {
    private String id = null;
    private String name = null;
    private Integer providerStickerId = null;
    private Integer providerPackageId = null;
    private String packageName = null;
    private MessengerTypeEnum messengerType = null;
    private StickerTypeEnum stickerType = null;
    private Long providerVersion = null;
    private String uriLocation = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public MessagingSticker name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessagingSticker providerStickerId(Integer providerStickerId) {
        this.providerStickerId = providerStickerId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The sticker Id of the sticker, assigned by the sticker provider.")
    @JsonProperty(value="providerStickerId")
    public Integer getProviderStickerId() {
        return this.providerStickerId;
    }

    public void setProviderStickerId(Integer providerStickerId) {
        this.providerStickerId = providerStickerId;
    }

    public MessagingSticker providerPackageId(Integer providerPackageId) {
        this.providerPackageId = providerPackageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The package Id of the sticker, assigned by the sticker provider.")
    @JsonProperty(value="providerPackageId")
    public Integer getProviderPackageId() {
        return this.providerPackageId;
    }

    public void setProviderPackageId(Integer providerPackageId) {
        this.providerPackageId = providerPackageId;
    }

    public MessagingSticker packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    @ApiModelProperty(example="null", value="The package name of the sticker, assigned by the sticker provider.")
    @JsonProperty(value="packageName")
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public MessagingSticker messengerType(MessengerTypeEnum messengerType) {
        this.messengerType = messengerType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the messenger provider.")
    @JsonProperty(value="messengerType")
    public MessengerTypeEnum getMessengerType() {
        return this.messengerType;
    }

    public void setMessengerType(MessengerTypeEnum messengerType) {
        this.messengerType = messengerType;
    }

    public MessagingSticker stickerType(StickerTypeEnum stickerType) {
        this.stickerType = stickerType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the sticker.")
    @JsonProperty(value="stickerType")
    public StickerTypeEnum getStickerType() {
        return this.stickerType;
    }

    public void setStickerType(StickerTypeEnum stickerType) {
        this.stickerType = stickerType;
    }

    public MessagingSticker providerVersion(Long providerVersion) {
        this.providerVersion = providerVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the sticker, assigned by the provider.")
    @JsonProperty(value="providerVersion")
    public Long getProviderVersion() {
        return this.providerVersion;
    }

    public void setProviderVersion(Long providerVersion) {
        this.providerVersion = providerVersion;
    }

    public MessagingSticker uriLocation(String uriLocation) {
        this.uriLocation = uriLocation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="uriLocation")
    public String getUriLocation() {
        return this.uriLocation;
    }

    public void setUriLocation(String uriLocation) {
        this.uriLocation = uriLocation;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingSticker messagingSticker = (MessagingSticker)o;
        return Objects.equals(this.id, messagingSticker.id) && Objects.equals(this.name, messagingSticker.name) && Objects.equals(this.providerStickerId, messagingSticker.providerStickerId) && Objects.equals(this.providerPackageId, messagingSticker.providerPackageId) && Objects.equals(this.packageName, messagingSticker.packageName) && Objects.equals((Object)this.messengerType, (Object)messagingSticker.messengerType) && Objects.equals((Object)this.stickerType, (Object)messagingSticker.stickerType) && Objects.equals(this.providerVersion, messagingSticker.providerVersion) && Objects.equals(this.uriLocation, messagingSticker.uriLocation) && Objects.equals(this.selfUri, messagingSticker.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.providerStickerId, this.providerPackageId, this.packageName, this.messengerType, this.stickerType, this.providerVersion, this.uriLocation, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagingSticker {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    providerStickerId: ").append(this.toIndentedString(this.providerStickerId)).append("\n");
        sb.append("    providerPackageId: ").append(this.toIndentedString(this.providerPackageId)).append("\n");
        sb.append("    packageName: ").append(this.toIndentedString(this.packageName)).append("\n");
        sb.append("    messengerType: ").append(this.toIndentedString((Object)this.messengerType)).append("\n");
        sb.append("    stickerType: ").append(this.toIndentedString((Object)this.stickerType)).append("\n");
        sb.append("    providerVersion: ").append(this.toIndentedString(this.providerVersion)).append("\n");
        sb.append("    uriLocation: ").append(this.toIndentedString(this.uriLocation)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StickerTypeEnumDeserializer.class)
    public static enum StickerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STANDARD("standard"),
        FREE("free"),
        PAID("paid");

        private String value;

        private StickerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StickerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StickerTypeEnum value : StickerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StickerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StickerTypeEnumDeserializer
    extends StdDeserializer<StickerTypeEnum> {
        public StickerTypeEnumDeserializer() {
            super(StickerTypeEnumDeserializer.class);
        }

        public StickerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StickerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MessengerTypeEnumDeserializer.class)
    public static enum MessengerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("sms"),
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        LINE("line"),
        WHATSAPP("whatsapp"),
        WEBMESSAGING("webmessaging");

        private String value;

        private MessengerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessengerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessengerTypeEnum value : MessengerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessengerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MessengerTypeEnumDeserializer
    extends StdDeserializer<MessengerTypeEnum> {
        public MessengerTypeEnumDeserializer() {
            super(MessengerTypeEnumDeserializer.class);
        }

        public MessengerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MessengerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

