/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Defines a SCIM email address.")
public class ScimEmail
implements Serializable {
    private String value = null;
    private TypeEnum type = null;
    private Boolean primary = null;

    public ScimEmail value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The email address. Is immutable if \"type\" is set to \"other\".")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ScimEmail type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of email address. \"value\" is immutable if \"type\" is set to \"other\".")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ScimEmail primary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the email address is the primary email address.")
    @JsonProperty(value="primary")
    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimEmail scimEmail = (ScimEmail)o;
        return Objects.equals(this.value, scimEmail.value) && Objects.equals((Object)this.type, (Object)scimEmail.type) && Objects.equals(this.primary, scimEmail.primary);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type, this.primary});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimEmail {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WORK("work"),
        OTHER("other");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

