/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class RoutingRule
implements Serializable {
    private OperatorEnum operator = null;
    private Integer threshold = null;
    private Double waitSeconds = null;

    public RoutingRule operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="matching operator.  MEETS_THRESHOLD matches any agent with a score at or above the rule's threshold.  ANY matches all specified agents, regardless of score.")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public RoutingRule threshold(Integer threshold) {
        this.threshold = threshold;
        return this;
    }

    @ApiModelProperty(example="null", value="threshold required for routing attempt (generally an agent score).  may be null for operator ANY.")
    @JsonProperty(value="threshold")
    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public RoutingRule waitSeconds(Double waitSeconds) {
        this.waitSeconds = waitSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="seconds to wait in this rule before moving to the next")
    @JsonProperty(value="waitSeconds")
    public Double getWaitSeconds() {
        return this.waitSeconds;
    }

    public void setWaitSeconds(Double waitSeconds) {
        this.waitSeconds = waitSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingRule routingRule = (RoutingRule)o;
        return Objects.equals((Object)this.operator, (Object)routingRule.operator) && Objects.equals(this.threshold, routingRule.threshold) && Objects.equals(this.waitSeconds, routingRule.waitSeconds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.threshold, this.waitSeconds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoutingRule {\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    threshold: ").append(this.toIndentedString(this.threshold)).append("\n");
        sb.append("    waitSeconds: ").append(this.toIndentedString(this.waitSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MEETS_THRESHOLD("MEETS_THRESHOLD"),
        ANY("ANY");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

