/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class TwitterIntegration
implements Serializable {
    private String id = null;
    private String name = null;
    private String accessTokenKey = null;
    private String consumerKey = null;
    private String username = null;
    private String userId = null;
    private String status = null;
    private TierEnum tier = null;
    private String envName = null;
    private DomainEntityRef recipient = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private DomainEntityRef createdBy = null;
    private DomainEntityRef modifiedBy = null;
    private Integer version = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", required=true, value="A unique Integration Id")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public TwitterIntegration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Twitter Integration")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TwitterIntegration accessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Access Token Key from Twitter messenger")
    @JsonProperty(value="accessTokenKey")
    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public void setAccessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
    }

    public TwitterIntegration consumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Consumer Key from Twitter messenger")
    @JsonProperty(value="consumerKey")
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public TwitterIntegration username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(example="null", value="The Username from Twitter")
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public TwitterIntegration userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="The UserId from Twitter")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public TwitterIntegration status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the Twitter Integration")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TwitterIntegration tier(TierEnum tier) {
        this.tier = tier;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of twitter account to be used for the integration")
    @JsonProperty(value="tier")
    public TierEnum getTier() {
        return this.tier;
    }

    public void setTier(TierEnum tier) {
        this.tier = tier;
    }

    public TwitterIntegration envName(String envName) {
        this.envName = envName;
        return this;
    }

    @ApiModelProperty(example="null", value="The Twitter environment name, e.g.: env-beta (required for premium tier)")
    @JsonProperty(value="envName")
    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public TwitterIntegration recipient(DomainEntityRef recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipient associated to the Twitter Integration. This recipient is used to associate a flow to an integration")
    @JsonProperty(value="recipient")
    public DomainEntityRef getRecipient() {
        return this.recipient;
    }

    public void setRecipient(DomainEntityRef recipient) {
        this.recipient = recipient;
    }

    public TwitterIntegration dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public TwitterIntegration dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public TwitterIntegration createdBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that created this Integration")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    public TwitterIntegration modifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that last modified this Integration")
    @JsonProperty(value="modifiedBy")
    public DomainEntityRef getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public TwitterIntegration version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version number required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterIntegration twitterIntegration = (TwitterIntegration)o;
        return Objects.equals(this.id, twitterIntegration.id) && Objects.equals(this.name, twitterIntegration.name) && Objects.equals(this.accessTokenKey, twitterIntegration.accessTokenKey) && Objects.equals(this.consumerKey, twitterIntegration.consumerKey) && Objects.equals(this.username, twitterIntegration.username) && Objects.equals(this.userId, twitterIntegration.userId) && Objects.equals(this.status, twitterIntegration.status) && Objects.equals((Object)this.tier, (Object)twitterIntegration.tier) && Objects.equals(this.envName, twitterIntegration.envName) && Objects.equals(this.recipient, twitterIntegration.recipient) && Objects.equals(this.dateCreated, twitterIntegration.dateCreated) && Objects.equals(this.dateModified, twitterIntegration.dateModified) && Objects.equals(this.createdBy, twitterIntegration.createdBy) && Objects.equals(this.modifiedBy, twitterIntegration.modifiedBy) && Objects.equals(this.version, twitterIntegration.version) && Objects.equals(this.selfUri, twitterIntegration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.accessTokenKey, this.consumerKey, this.username, this.userId, this.status, this.tier, this.envName, this.recipient, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.version, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TwitterIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accessTokenKey: ").append(this.toIndentedString(this.accessTokenKey)).append("\n");
        sb.append("    consumerKey: ").append(this.toIndentedString(this.consumerKey)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tier: ").append(this.toIndentedString((Object)this.tier)).append("\n");
        sb.append("    envName: ").append(this.toIndentedString(this.envName)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TierEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PREMIUM("premium"),
        ENTERPRISE("enterprise");

        private String value;

        private TierEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TierEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TierEnum value : TierEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TierEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

