/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ModelingProcessingError;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ModelingStatusResponse
implements Serializable {
    private String id = null;
    private StatusEnum status = null;
    private List<ModelingProcessingError> errorDetails = new ArrayList<ModelingProcessingError>();
    private String modelingResultUri = null;

    @ApiModelProperty(example="null", value="The ID generated for the modeling job.  Use to GET result when job is completed.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The status of the modeling job.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public ModelingStatusResponse errorDetails(List<ModelingProcessingError> errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="If the request could not be properly processed, error details will be given here.")
    @JsonProperty(value="errorDetails")
    public List<ModelingProcessingError> getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(List<ModelingProcessingError> errorDetails) {
        this.errorDetails = errorDetails;
    }

    @ApiModelProperty(example="null", value="The uri of the modeling result. It has a value if the status is either 'Success', 'PartialFailure', or 'Failed'.")
    @JsonProperty(value="modelingResultUri")
    public String getModelingResultUri() {
        return this.modelingResultUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelingStatusResponse modelingStatusResponse = (ModelingStatusResponse)o;
        return Objects.equals(this.id, modelingStatusResponse.id) && Objects.equals((Object)this.status, (Object)modelingStatusResponse.status) && Objects.equals(this.errorDetails, modelingStatusResponse.errorDetails) && Objects.equals(this.modelingResultUri, modelingStatusResponse.modelingResultUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.errorDetails, this.modelingResultUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModelingStatusResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    modelingResultUri: ").append(this.toIndentedString(this.modelingResultUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        SUCCESS("Success"),
        FAILED("Failed"),
        ONGOING("Ongoing"),
        PARTIALFAILURE("PartialFailure");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

