/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ConversationReference;
import com.mypurecloud.sdk.v2.model.DocumentReference;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Coaching appointment response")
public class CoachingAppointmentResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Date dateStart = null;
    private Integer lengthInMinutes = null;
    private StatusEnum status = null;
    private UserReference facilitator = null;
    private List<UserReference> attendees = new ArrayList<UserReference>();
    private UserReference createdBy = null;
    private Date dateCreated = null;
    private UserReference modifiedBy = null;
    private Date dateModified = null;
    private List<ConversationReference> conversations = new ArrayList<ConversationReference>();
    private List<DocumentReference> documents = new ArrayList<DocumentReference>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The name of coaching appointment")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The description of coaching appointment")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="The date/time the coaching appointment starts. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    @ApiModelProperty(example="null", value="The duration of coaching appointment in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    @ApiModelProperty(example="null", value="The status of coaching appointment")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public CoachingAppointmentResponse facilitator(UserReference facilitator) {
        this.facilitator = facilitator;
        return this;
    }

    @ApiModelProperty(example="null", value="The facilitator of coaching appointment")
    @JsonProperty(value="facilitator")
    public UserReference getFacilitator() {
        return this.facilitator;
    }

    public void setFacilitator(UserReference facilitator) {
        this.facilitator = facilitator;
    }

    public CoachingAppointmentResponse attendees(List<UserReference> attendees) {
        this.attendees = attendees;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of attendees attending the coaching")
    @JsonProperty(value="attendees")
    public List<UserReference> getAttendees() {
        return this.attendees;
    }

    public void setAttendees(List<UserReference> attendees) {
        this.attendees = attendees;
    }

    public CoachingAppointmentResponse createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who created the coaching appointment")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="The date/time the coaching appointment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public CoachingAppointmentResponse modifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The last user to modify the coaching appointment")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @ApiModelProperty(example="null", value="The date/time the coaching appointment was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public CoachingAppointmentResponse conversations(List<ConversationReference> conversations) {
        this.conversations = conversations;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of conversations associated with coaching appointment.")
    @JsonProperty(value="conversations")
    public List<ConversationReference> getConversations() {
        return this.conversations;
    }

    public void setConversations(List<ConversationReference> conversations) {
        this.conversations = conversations;
    }

    public CoachingAppointmentResponse documents(List<DocumentReference> documents) {
        this.documents = documents;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of documents associated with coaching appointment.")
    @JsonProperty(value="documents")
    public List<DocumentReference> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<DocumentReference> documents) {
        this.documents = documents;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoachingAppointmentResponse coachingAppointmentResponse = (CoachingAppointmentResponse)o;
        return Objects.equals(this.id, coachingAppointmentResponse.id) && Objects.equals(this.name, coachingAppointmentResponse.name) && Objects.equals(this.description, coachingAppointmentResponse.description) && Objects.equals(this.dateStart, coachingAppointmentResponse.dateStart) && Objects.equals(this.lengthInMinutes, coachingAppointmentResponse.lengthInMinutes) && Objects.equals((Object)this.status, (Object)coachingAppointmentResponse.status) && Objects.equals(this.facilitator, coachingAppointmentResponse.facilitator) && Objects.equals(this.attendees, coachingAppointmentResponse.attendees) && Objects.equals(this.createdBy, coachingAppointmentResponse.createdBy) && Objects.equals(this.dateCreated, coachingAppointmentResponse.dateCreated) && Objects.equals(this.modifiedBy, coachingAppointmentResponse.modifiedBy) && Objects.equals(this.dateModified, coachingAppointmentResponse.dateModified) && Objects.equals(this.conversations, coachingAppointmentResponse.conversations) && Objects.equals(this.documents, coachingAppointmentResponse.documents) && Objects.equals(this.selfUri, coachingAppointmentResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.dateStart, this.lengthInMinutes, this.status, this.facilitator, this.attendees, this.createdBy, this.dateCreated, this.modifiedBy, this.dateModified, this.conversations, this.documents, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoachingAppointmentResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    facilitator: ").append(this.toIndentedString(this.facilitator)).append("\n");
        sb.append("    attendees: ").append(this.toIndentedString(this.attendees)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    conversations: ").append(this.toIndentedString(this.conversations)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SCHEDULED("Scheduled"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        INVALIDSCHEDULE("InvalidSchedule");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

