/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.connector.ning;

import com.google.common.util.concurrent.Futures;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.connector.ApiClientConnector;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorRequest;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorResponse;
import com.mypurecloud.sdk.v2.connector.ning.AsyncHttpResponse;
import java.util.Map;
import java.util.concurrent.Future;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.uri.Uri;

public class AsyncHttpClientConnector
implements ApiClientConnector {
    private final AsyncHttpClient client;

    public AsyncHttpClientConnector(AsyncHttpClient client) {
        this.client = client;
    }

    @Override
    public ApiClientConnectorResponse invoke(ApiClientConnectorRequest request) throws Exception {
        return null;
    }

    @Override
    public Future<ApiClientConnectorResponse> invokeAsync(ApiClientConnectorRequest request, AsyncApiCallback<ApiClientConnectorResponse> callback) {
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)new RequestBuilder().setUri(Uri.create((String)request.getUrl()))).setMethod(request.getMethod());
            for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
                builder = (RequestBuilder)builder.addHeader((CharSequence)header.getKey(), header.getValue());
            }
            if (request.hasBody()) {
                builder = (RequestBuilder)builder.setBody(request.readBody());
            }
            return this.client.executeRequest(builder, (AsyncHandler)new AsyncCompletionHandler<ApiClientConnectorResponse>(){

                public ApiClientConnectorResponse onCompleted(Response response) throws Exception {
                    return new AsyncHttpResponse(response);
                }
            });
        }
        catch (Throwable exception) {
            callback.onFailed(exception);
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

