/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ContactList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutOutboundContactlistRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String contactListId;
    private ContactList body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getContactListId() {
        return this.contactListId;
    }

    public void setContactListId(String contactListId) {
        this.contactListId = contactListId;
    }

    public PutOutboundContactlistRequest withContactListId(String contactListId) {
        this.setContactListId(contactListId);
        return this;
    }

    public ContactList getBody() {
        return this.body;
    }

    public void setBody(ContactList body) {
        this.body = body;
    }

    public PutOutboundContactlistRequest withBody(ContactList body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOutboundContactlistRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ContactList> withHttpInfo() throws ApiException {
        if (this.contactListId == null) {
            throw new ApiException(400, "Missing the required parameter 'contactListId' when building request for PutOutboundContactlistRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PutOutboundContactlistRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/outbound/contactlists/{contactListId}").withPathParameter("contactListId", this.contactListId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String contactListId, ContactList body) {
        return new Builder().withRequiredParams(contactListId, body);
    }

    public static class Builder {
        private final PutOutboundContactlistRequest request = new PutOutboundContactlistRequest();

        private Builder() {
        }

        public Builder withContactListId(String contactListId) {
            this.request.setContactListId(contactListId);
            return this;
        }

        public Builder withBody(ContactList body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String contactListId, ContactList body) {
            this.request.setContactListId(contactListId);
            this.request.setBody(body);
            return this;
        }

        public PutOutboundContactlistRequest build() {
            return this.request;
        }
    }
}

