/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CalibrationCreate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostQualityCalibrationsRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private CalibrationCreate body;
    private String expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public CalibrationCreate getBody() {
        return this.body;
    }

    public void setBody(CalibrationCreate body) {
        this.body = body;
    }

    public PostQualityCalibrationsRequest withBody(CalibrationCreate body) {
        this.setBody(body);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public PostQualityCalibrationsRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostQualityCalibrationsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CalibrationCreate> withHttpInfo() throws ApiException {
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PostQualityCalibrationsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/quality/calibrations").withQueryParameters("expand", "", this.expand).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CalibrationCreate body) {
        return new Builder().withRequiredParams(body);
    }

    public static class Builder {
        private final PostQualityCalibrationsRequest request = new PostQualityCalibrationsRequest();

        private Builder() {
        }

        public Builder withBody(CalibrationCreate body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withRequiredParams(CalibrationCreate body) {
            this.request.setBody(body);
            return this;
        }

        public PostQualityCalibrationsRequest build() {
            return this.request;
        }
    }
}

