/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ContactCallbackRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostOutboundCampaignCallbackScheduleRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String campaignId;
    private ContactCallbackRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public PostOutboundCampaignCallbackScheduleRequest withCampaignId(String campaignId) {
        this.setCampaignId(campaignId);
        return this;
    }

    public ContactCallbackRequest getBody() {
        return this.body;
    }

    public void setBody(ContactCallbackRequest body) {
        this.body = body;
    }

    public PostOutboundCampaignCallbackScheduleRequest withBody(ContactCallbackRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostOutboundCampaignCallbackScheduleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ContactCallbackRequest> withHttpInfo() throws ApiException {
        if (this.campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when building request for PostOutboundCampaignCallbackScheduleRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PostOutboundCampaignCallbackScheduleRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/outbound/campaigns/{campaignId}/callback/schedule").withPathParameter("campaignId", this.campaignId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String campaignId, ContactCallbackRequest body) {
        return new Builder().withRequiredParams(campaignId, body);
    }

    public static class Builder {
        private final PostOutboundCampaignCallbackScheduleRequest request = new PostOutboundCampaignCallbackScheduleRequest();

        private Builder() {
        }

        public Builder withCampaignId(String campaignId) {
            this.request.setCampaignId(campaignId);
            return this;
        }

        public Builder withBody(ContactCallbackRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String campaignId, ContactCallbackRequest body) {
            this.request.setCampaignId(campaignId);
            this.request.setBody(body);
            return this;
        }

        public PostOutboundCampaignCallbackScheduleRequest build() {
            return this.request;
        }
    }
}

