/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.TransferRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostConversationParticipantReplaceRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String conversationId;
    private String participantId;
    private TransferRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationParticipantReplaceRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PostConversationParticipantReplaceRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public TransferRequest getBody() {
        return this.body;
    }

    public void setBody(TransferRequest body) {
        this.body = body;
    }

    public PostConversationParticipantReplaceRequest withBody(TransferRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationParticipantReplaceRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<TransferRequest> withHttpInfo() throws ApiException {
        if (this.conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when building request for PostConversationParticipantReplaceRequest.");
        }
        if (this.participantId == null) {
            throw new ApiException(400, "Missing the required parameter 'participantId' when building request for PostConversationParticipantReplaceRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PostConversationParticipantReplaceRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/{conversationId}/participants/{participantId}/replace").withPathParameter("conversationId", this.conversationId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String participantId, TransferRequest body) {
        return new Builder().withRequiredParams(conversationId, participantId, body);
    }

    public static class Builder {
        private final PostConversationParticipantReplaceRequest request = new PostConversationParticipantReplaceRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(TransferRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String participantId, TransferRequest body) {
            this.request.setConversationId(conversationId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationParticipantReplaceRequest build() {
            return this.request;
        }
    }
}

