/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DeleteQualityFormRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String formId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public DeleteQualityFormRequest withFormId(String formId) {
        this.setFormId(formId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteQualityFormRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when building request for DeleteQualityFormRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/quality/forms/{formId}").withPathParameter("formId", this.formId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String formId) {
        return new Builder().withRequiredParams(formId);
    }

    public static class Builder {
        private final DeleteQualityFormRequest request = new DeleteQualityFormRequest();

        private Builder() {
        }

        public Builder withFormId(String formId) {
            this.request.setFormId(formId);
            return this;
        }

        public Builder withRequiredParams(String formId) {
            this.request.setFormId(formId);
            return this;
        }

        public DeleteQualityFormRequest build() {
            return this.request;
        }
    }
}

