/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteOauthClientRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientsRequest;
import com.mypurecloud.sdk.v2.api.request.PostOauthClientSecretRequest;
import com.mypurecloud.sdk.v2.api.request.PostOauthClientsRequest;
import com.mypurecloud.sdk.v2.api.request.PutOauthClientRequest;
import com.mypurecloud.sdk.v2.model.OAuthClient;
import com.mypurecloud.sdk.v2.model.OAuthClientEntityListing;
import java.util.ArrayList;
import java.util.HashMap;

public class OAuthApi {
    private final ApiClient pcapiClient;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteOauthClient(String clientId) throws ApiException {
        this.deleteOauthClientWithHttpInfo(clientId);
    }

    public ApiResponse<Void> deleteOauthClientWithHttpInfo(String clientId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling deleteOauthClient");
        }
        String pclocalVarPath = "/api/v2/oauth/clients/{clientId}".replaceAll("\\{format\\}", "json").replaceAll("\\{clientId\\}", this.pcapiClient.escapeString(clientId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteOauthClient(DeleteOauthClientRequest request) throws ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteOauthClient(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public OAuthClient getOauthClient(String clientId) throws ApiException {
        return this.getOauthClientWithHttpInfo(clientId).getBody();
    }

    public ApiResponse<OAuthClient> getOauthClientWithHttpInfo(String clientId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling getOauthClient");
        }
        String pclocalVarPath = "/api/v2/oauth/clients/{clientId}".replaceAll("\\{format\\}", "json").replaceAll("\\{clientId\\}", this.pcapiClient.escapeString(clientId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OAuthClient>(){});
    }

    public OAuthClient getOauthClient(GetOauthClientRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
    }

    public ApiResponse<OAuthClient> getOauthClient(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OAuthClient>(){});
    }

    public OAuthClientEntityListing getOauthClients() throws ApiException {
        return this.getOauthClientsWithHttpInfo().getBody();
    }

    public ApiResponse<OAuthClientEntityListing> getOauthClientsWithHttpInfo() throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/oauth/clients".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OAuthClientEntityListing>(){});
    }

    public OAuthClientEntityListing getOauthClients(GetOauthClientsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OAuthClientEntityListing>(){});
    }

    public ApiResponse<OAuthClientEntityListing> getOauthClients(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OAuthClientEntityListing>(){});
    }

    public OAuthClient postOauthClientSecret(String clientId) throws ApiException {
        return this.postOauthClientSecretWithHttpInfo(clientId).getBody();
    }

    public ApiResponse<OAuthClient> postOauthClientSecretWithHttpInfo(String clientId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling postOauthClientSecret");
        }
        String pclocalVarPath = "/api/v2/oauth/clients/{clientId}/secret".replaceAll("\\{format\\}", "json").replaceAll("\\{clientId\\}", this.pcapiClient.escapeString(clientId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OAuthClient>(){});
    }

    public OAuthClient postOauthClientSecret(PostOauthClientSecretRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
    }

    public ApiResponse<OAuthClient> postOauthClientSecret(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OAuthClient>(){});
    }

    public OAuthClient postOauthClients(OAuthClient body) throws ApiException {
        return this.postOauthClientsWithHttpInfo(body).getBody();
    }

    public ApiResponse<OAuthClient> postOauthClientsWithHttpInfo(OAuthClient body) throws ApiException {
        OAuthClient pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postOauthClients");
        }
        String pclocalVarPath = "/api/v2/oauth/clients".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OAuthClient>(){});
    }

    public OAuthClient postOauthClients(PostOauthClientsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
    }

    public ApiResponse<OAuthClient> postOauthClients(ApiRequest<OAuthClient> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OAuthClient>(){});
    }

    public OAuthClient putOauthClient(String clientId, OAuthClient body) throws ApiException {
        return this.putOauthClientWithHttpInfo(clientId, body).getBody();
    }

    public ApiResponse<OAuthClient> putOauthClientWithHttpInfo(String clientId, OAuthClient body) throws ApiException {
        OAuthClient pclocalVarPostBody = body;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling putOauthClient");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putOauthClient");
        }
        String pclocalVarPath = "/api/v2/oauth/clients/{clientId}".replaceAll("\\{format\\}", "json").replaceAll("\\{clientId\\}", this.pcapiClient.escapeString(clientId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OAuthClient>(){});
    }

    public OAuthClient putOauthClient(PutOauthClientRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
    }

    public ApiResponse<OAuthClient> putOauthClient(ApiRequest<OAuthClient> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OAuthClient>(){});
    }
}

