/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.EdgeLine;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutTelephonyProvidersEdgeLineRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String edgeId;
    private String lineId;
    private EdgeLine body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getEdgeId() {
        return this.edgeId;
    }

    public void setEdgeId(String edgeId) {
        this.edgeId = edgeId;
    }

    public PutTelephonyProvidersEdgeLineRequest withEdgeId(String edgeId) {
        this.setEdgeId(edgeId);
        return this;
    }

    public String getLineId() {
        return this.lineId;
    }

    public void setLineId(String lineId) {
        this.lineId = lineId;
    }

    public PutTelephonyProvidersEdgeLineRequest withLineId(String lineId) {
        this.setLineId(lineId);
        return this;
    }

    public EdgeLine getBody() {
        return this.body;
    }

    public void setBody(EdgeLine body) {
        this.body = body;
    }

    public PutTelephonyProvidersEdgeLineRequest withBody(EdgeLine body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutTelephonyProvidersEdgeLineRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<EdgeLine> withHttpInfo() throws ApiException {
        if (this.edgeId == null) {
            throw new ApiException(400, "Missing the required parameter 'edgeId' when building request for PutTelephonyProvidersEdgeLineRequest.");
        }
        if (this.lineId == null) {
            throw new ApiException(400, "Missing the required parameter 'lineId' when building request for PutTelephonyProvidersEdgeLineRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PutTelephonyProvidersEdgeLineRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/telephony/providers/edges/{edgeId}/lines/{lineId}").withPathParameter("edgeId", this.edgeId).withPathParameter("lineId", this.lineId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String edgeId, String lineId, EdgeLine body) {
        return new Builder().withRequiredParams(edgeId, lineId, body);
    }

    public static class Builder {
        private final PutTelephonyProvidersEdgeLineRequest request = new PutTelephonyProvidersEdgeLineRequest();

        private Builder() {
        }

        public Builder withEdgeId(String edgeId) {
            this.request.setEdgeId(edgeId);
            return this;
        }

        public Builder withLineId(String lineId) {
            this.request.setLineId(lineId);
            return this;
        }

        public Builder withBody(EdgeLine body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String edgeId, String lineId, EdgeLine body) {
            this.request.setEdgeId(edgeId);
            this.request.setLineId(lineId);
            this.request.setBody(body);
            return this;
        }

        public PutTelephonyProvidersEdgeLineRequest build() {
            return this.request;
        }
    }
}

