/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Queue;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutRoutingQueueRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String queueId;
    private Queue body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PutRoutingQueueRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public Queue getBody() {
        return this.body;
    }

    public void setBody(Queue body) {
        this.body = body;
    }

    public PutRoutingQueueRequest withBody(Queue body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutRoutingQueueRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Queue> withHttpInfo() throws ApiException {
        if (this.queueId == null) {
            throw new ApiException(400, "Missing the required parameter 'queueId' when building request for PutRoutingQueueRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PutRoutingQueueRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/routing/queues/{queueId}").withPathParameter("queueId", this.queueId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId, Queue body) {
        return new Builder().withRequiredParams(queueId, body);
    }

    public static class Builder {
        private final PutRoutingQueueRequest request = new PutRoutingQueueRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withBody(Queue body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String queueId, Queue body) {
            this.request.setQueueId(queueId);
            this.request.setBody(body);
            return this;
        }

        public PutRoutingQueueRequest build() {
            return this.request;
        }
    }
}

