/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Workspace;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutContentmanagementWorkspaceRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String workspaceId;
    private Workspace body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public PutContentmanagementWorkspaceRequest withWorkspaceId(String workspaceId) {
        this.setWorkspaceId(workspaceId);
        return this;
    }

    public Workspace getBody() {
        return this.body;
    }

    public void setBody(Workspace body) {
        this.body = body;
    }

    public PutContentmanagementWorkspaceRequest withBody(Workspace body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutContentmanagementWorkspaceRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Workspace> withHttpInfo() throws ApiException {
        if (this.workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when building request for PutContentmanagementWorkspaceRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PutContentmanagementWorkspaceRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/contentmanagement/workspaces/{workspaceId}").withPathParameter("workspaceId", this.workspaceId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String workspaceId, Workspace body) {
        return new Builder().withRequiredParams(workspaceId, body);
    }

    public static class Builder {
        private final PutContentmanagementWorkspaceRequest request = new PutContentmanagementWorkspaceRequest();

        private Builder() {
        }

        public Builder withWorkspaceId(String workspaceId) {
            this.request.setWorkspaceId(workspaceId);
            return this;
        }

        public Builder withBody(Workspace body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String workspaceId, Workspace body) {
            this.request.setWorkspaceId(workspaceId);
            this.request.setBody(body);
            return this;
        }

        public PutContentmanagementWorkspaceRequest build() {
            return this.request;
        }
    }
}

