/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteAttributeRequest;
import com.mypurecloud.sdk.v2.api.request.GetAttributeRequest;
import com.mypurecloud.sdk.v2.api.request.GetAttributesRequest;
import com.mypurecloud.sdk.v2.api.request.PostAttributesQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostAttributesRequest;
import com.mypurecloud.sdk.v2.api.request.PutAttributeRequest;
import com.mypurecloud.sdk.v2.model.Attribute;
import com.mypurecloud.sdk.v2.model.AttributeEntityListing;
import com.mypurecloud.sdk.v2.model.AttributeQueryRequest;
import java.util.ArrayList;
import java.util.HashMap;

public class AttributesApi {
    private final ApiClient pcapiClient;

    public AttributesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttributesApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteAttribute(String attributeId) throws ApiException {
        this.deleteAttributeWithHttpInfo(attributeId);
    }

    public ApiResponse<Void> deleteAttributeWithHttpInfo(String attributeId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (attributeId == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeId' when calling deleteAttribute");
        }
        String pclocalVarPath = "/api/v2/attributes/{attributeId}".replaceAll("\\{format\\}", "json").replaceAll("\\{attributeId\\}", this.pcapiClient.escapeString(attributeId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteAttribute(DeleteAttributeRequest request) throws ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteAttribute(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public Attribute getAttribute(String attributeId) throws ApiException {
        return this.getAttributeWithHttpInfo(attributeId).getBody();
    }

    public ApiResponse<Attribute> getAttributeWithHttpInfo(String attributeId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (attributeId == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeId' when calling getAttribute");
        }
        String pclocalVarPath = "/api/v2/attributes/{attributeId}".replaceAll("\\{format\\}", "json").replaceAll("\\{attributeId\\}", this.pcapiClient.escapeString(attributeId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Attribute>(){});
    }

    public Attribute getAttribute(GetAttributeRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Attribute>(){});
    }

    public ApiResponse<Attribute> getAttribute(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Attribute>(){});
    }

    public AttributeEntityListing getAttributes(Integer pageNumber, Integer pageSize) throws ApiException {
        return this.getAttributesWithHttpInfo(pageNumber, pageSize).getBody();
    }

    public ApiResponse<AttributeEntityListing> getAttributesWithHttpInfo(Integer pageNumber, Integer pageSize) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/attributes".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<AttributeEntityListing>(){});
    }

    public AttributeEntityListing getAttributes(GetAttributesRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<AttributeEntityListing>(){});
    }

    public ApiResponse<AttributeEntityListing> getAttributes(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<AttributeEntityListing>(){});
    }

    public Attribute postAttributes(Attribute body) throws ApiException {
        return this.postAttributesWithHttpInfo(body).getBody();
    }

    public ApiResponse<Attribute> postAttributesWithHttpInfo(Attribute body) throws ApiException {
        Attribute pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postAttributes");
        }
        String pclocalVarPath = "/api/v2/attributes".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Attribute>(){});
    }

    public Attribute postAttributes(PostAttributesRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Attribute>(){});
    }

    public ApiResponse<Attribute> postAttributes(ApiRequest<Attribute> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Attribute>(){});
    }

    public AttributeEntityListing postAttributesQuery(AttributeQueryRequest body) throws ApiException {
        return this.postAttributesQueryWithHttpInfo(body).getBody();
    }

    public ApiResponse<AttributeEntityListing> postAttributesQueryWithHttpInfo(AttributeQueryRequest body) throws ApiException {
        AttributeQueryRequest pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postAttributesQuery");
        }
        String pclocalVarPath = "/api/v2/attributes/query".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<AttributeEntityListing>(){});
    }

    public AttributeEntityListing postAttributesQuery(PostAttributesQueryRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<AttributeEntityListing>(){});
    }

    public ApiResponse<AttributeEntityListing> postAttributesQuery(ApiRequest<AttributeQueryRequest> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<AttributeEntityListing>(){});
    }

    public Attribute putAttribute(String attributeId, Attribute body) throws ApiException {
        return this.putAttributeWithHttpInfo(attributeId, body).getBody();
    }

    public ApiResponse<Attribute> putAttributeWithHttpInfo(String attributeId, Attribute body) throws ApiException {
        Attribute pclocalVarPostBody = body;
        if (attributeId == null) {
            throw new ApiException(400, "Missing the required parameter 'attributeId' when calling putAttribute");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putAttribute");
        }
        String pclocalVarPath = "/api/v2/attributes/{attributeId}".replaceAll("\\{format\\}", "json").replaceAll("\\{attributeId\\}", this.pcapiClient.escapeString(attributeId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Attribute>(){});
    }

    public Attribute putAttribute(PutAttributeRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Attribute>(){});
    }

    public ApiResponse<Attribute> putAttribute(ApiRequest<Attribute> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Attribute>(){});
    }
}

