/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class RoutingStatusAlert
implements Serializable {
    private String id = null;
    private String name = null;
    private User agent = null;
    private RoutingStatusEnum routingStatus = null;
    private Integer routingLimitInSeconds = null;
    private String ruleId = null;
    private Date startDate = null;
    private Date endDate = null;
    private List<User> notificationUsers = new ArrayList<User>();
    private List<AlertTypesEnum> alertTypes = new ArrayList<AlertTypesEnum>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public RoutingStatusAlert name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the rule")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RoutingStatusAlert agent(User agent) {
        this.agent = agent;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The agent whose routing status will be watched.")
    @JsonProperty(value="agent")
    public User getAgent() {
        return this.agent;
    }

    public void setAgent(User agent) {
        this.agent = agent;
    }

    public RoutingStatusAlert routingStatus(RoutingStatusEnum routingStatus) {
        this.routingStatus = routingStatus;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The routing status on which to alert.")
    @JsonProperty(value="routingStatus")
    public RoutingStatusEnum getRoutingStatus() {
        return this.routingStatus;
    }

    public void setRoutingStatus(RoutingStatusEnum routingStatus) {
        this.routingStatus = routingStatus;
    }

    public RoutingStatusAlert routingLimitInSeconds(Integer routingLimitInSeconds) {
        this.routingLimitInSeconds = routingLimitInSeconds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The number of seconds to wait before alerting based upon the agent's routing status.")
    @JsonProperty(value="routingLimitInSeconds")
    public Integer getRoutingLimitInSeconds() {
        return this.routingLimitInSeconds;
    }

    public void setRoutingLimitInSeconds(Integer routingLimitInSeconds) {
        this.routingLimitInSeconds = routingLimitInSeconds;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the rule.")
    @JsonProperty(value="ruleId")
    public String getRuleId() {
        return this.ruleId;
    }

    @ApiModelProperty(example="null", required=true, value="The date/time the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    @ApiModelProperty(example="null", value="The date/time the owning rule exiting in alarm status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public RoutingStatusAlert notificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ids of users who were notified of alarm state change.")
    @JsonProperty(value="notificationUsers")
    public List<User> getNotificationUsers() {
        return this.notificationUsers;
    }

    public void setNotificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
    }

    public RoutingStatusAlert alertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A collection of notification methods.")
    @JsonProperty(value="alertTypes")
    public List<AlertTypesEnum> getAlertTypes() {
        return this.alertTypes;
    }

    public void setAlertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingStatusAlert routingStatusAlert = (RoutingStatusAlert)o;
        return Objects.equals(this.id, routingStatusAlert.id) && Objects.equals(this.name, routingStatusAlert.name) && Objects.equals(this.agent, routingStatusAlert.agent) && Objects.equals((Object)this.routingStatus, (Object)routingStatusAlert.routingStatus) && Objects.equals(this.routingLimitInSeconds, routingStatusAlert.routingLimitInSeconds) && Objects.equals(this.ruleId, routingStatusAlert.ruleId) && Objects.equals(this.startDate, routingStatusAlert.startDate) && Objects.equals(this.endDate, routingStatusAlert.endDate) && Objects.equals(this.notificationUsers, routingStatusAlert.notificationUsers) && Objects.equals(this.alertTypes, routingStatusAlert.alertTypes) && Objects.equals(this.selfUri, routingStatusAlert.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.agent, this.routingStatus, this.routingLimitInSeconds, this.ruleId, this.startDate, this.endDate, this.notificationUsers, this.alertTypes, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoutingStatusAlert {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    agent: ").append(this.toIndentedString(this.agent)).append("\n");
        sb.append("    routingStatus: ").append(this.toIndentedString((Object)this.routingStatus)).append("\n");
        sb.append("    routingLimitInSeconds: ").append(this.toIndentedString(this.routingLimitInSeconds)).append("\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    notificationUsers: ").append(this.toIndentedString(this.notificationUsers)).append("\n");
        sb.append("    alertTypes: ").append(this.toIndentedString(this.alertTypes)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AlertTypesEnum {
        SMS("SMS"),
        DEVICE("DEVICE"),
        EMAIL("EMAIL");

        private String value;

        private AlertTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlertTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlertTypesEnum value : AlertTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlertTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum RoutingStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OFF_QUEUE("OFF_QUEUE"),
        IDLE("IDLE"),
        INTERACTING("INTERACTING"),
        NOT_RESPONDING("NOT_RESPONDING"),
        COMMUNICATING("COMMUNICATING");

        private String value;

        private RoutingStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RoutingStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RoutingStatusEnum value : RoutingStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RoutingStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

