/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ContactSort;
import com.mypurecloud.sdk.v2.model.PhoneColumn;
import com.mypurecloud.sdk.v2.model.RestErrorDetail;
import com.mypurecloud.sdk.v2.model.UriReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Campaign
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private UriReference contactList = null;
    private UriReference queue = null;
    private DialingModeEnum dialingMode = null;
    private UriReference script = null;
    private UriReference edgeGroup = null;
    private String campaignStatus = null;
    private List<PhoneColumn> phoneColumns = new ArrayList<PhoneColumn>();
    private Double abandonRate = null;
    private List<UriReference> dncLists = new ArrayList<UriReference>();
    private UriReference callableTimeSet = null;
    private UriReference callAnalysisResponseSet = null;
    private List<RestErrorDetail> errors = new ArrayList<RestErrorDetail>();
    private String callerName = null;
    private String callerAddress = null;
    private Integer outboundLineCount = null;
    private List<UriReference> ruleSets = new ArrayList<UriReference>();
    private Boolean skipPreviewDisabled = null;
    private Long previewTimeOutSeconds = null;
    private ContactSort contactSort = null;
    private Integer noAnswerTimeout = null;
    private String callAnalysisLanguage = null;
    private Integer priority = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Campaign name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public Campaign version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Campaign contactList(UriReference contactList) {
        this.contactList = contactList;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="identifier of the contact list for the campaign")
    @JsonProperty(value="contactList")
    public UriReference getContactList() {
        return this.contactList;
    }

    public void setContactList(UriReference contactList) {
        this.contactList = contactList;
    }

    public Campaign queue(UriReference queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="identifier of the agent assignment queue, required for all dialing modes other than agentless")
    @JsonProperty(value="queue")
    public UriReference getQueue() {
        return this.queue;
    }

    public void setQueue(UriReference queue) {
        this.queue = queue;
    }

    public Campaign dialingMode(DialingModeEnum dialingMode) {
        this.dialingMode = dialingMode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="dialing mode of the campaign")
    @JsonProperty(value="dialingMode")
    public DialingModeEnum getDialingMode() {
        return this.dialingMode;
    }

    public void setDialingMode(DialingModeEnum dialingMode) {
        this.dialingMode = dialingMode;
    }

    public Campaign script(UriReference script) {
        this.script = script;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="identifier of the campaign script, required for all dialing modes other than agentless")
    @JsonProperty(value="script")
    public UriReference getScript() {
        return this.script;
    }

    public void setScript(UriReference script) {
        this.script = script;
    }

    public Campaign edgeGroup(UriReference edgeGroup) {
        this.edgeGroup = edgeGroup;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="identifier of the edge group, required for all dialing modes other than preview")
    @JsonProperty(value="edgeGroup")
    public UriReference getEdgeGroup() {
        return this.edgeGroup;
    }

    public void setEdgeGroup(UriReference edgeGroup) {
        this.edgeGroup = edgeGroup;
    }

    public Campaign campaignStatus(String campaignStatus) {
        this.campaignStatus = campaignStatus;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="status of the campaign; can be set to 'on' or 'off'")
    @JsonProperty(value="campaignStatus")
    public String getCampaignStatus() {
        return this.campaignStatus;
    }

    public void setCampaignStatus(String campaignStatus) {
        this.campaignStatus = campaignStatus;
    }

    public Campaign phoneColumns(List<PhoneColumn> phoneColumns) {
        this.phoneColumns = phoneColumns;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="the contact list phone columns to be called for the campaign")
    @JsonProperty(value="phoneColumns")
    public List<PhoneColumn> getPhoneColumns() {
        return this.phoneColumns;
    }

    public void setPhoneColumns(List<PhoneColumn> phoneColumns) {
        this.phoneColumns = phoneColumns;
    }

    public Campaign abandonRate(Double abandonRate) {
        this.abandonRate = abandonRate;
        return this;
    }

    @ApiModelProperty(example="null", value="the targeted abandon rate percentage")
    @JsonProperty(value="abandonRate")
    public Double getAbandonRate() {
        return this.abandonRate;
    }

    public void setAbandonRate(Double abandonRate) {
        this.abandonRate = abandonRate;
    }

    public Campaign dncLists(List<UriReference> dncLists) {
        this.dncLists = dncLists;
        return this;
    }

    @ApiModelProperty(example="null", value="identifiers of the do not call lists")
    @JsonProperty(value="dncLists")
    public List<UriReference> getDncLists() {
        return this.dncLists;
    }

    public void setDncLists(List<UriReference> dncLists) {
        this.dncLists = dncLists;
    }

    public Campaign callableTimeSet(UriReference callableTimeSet) {
        this.callableTimeSet = callableTimeSet;
        return this;
    }

    @ApiModelProperty(example="null", value="the identifier of the callable time set")
    @JsonProperty(value="callableTimeSet")
    public UriReference getCallableTimeSet() {
        return this.callableTimeSet;
    }

    public void setCallableTimeSet(UriReference callableTimeSet) {
        this.callableTimeSet = callableTimeSet;
    }

    public Campaign callAnalysisResponseSet(UriReference callAnalysisResponseSet) {
        this.callAnalysisResponseSet = callAnalysisResponseSet;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="the identifier of the call analysis response set, required for all dialing modes other than preview")
    @JsonProperty(value="callAnalysisResponseSet")
    public UriReference getCallAnalysisResponseSet() {
        return this.callAnalysisResponseSet;
    }

    public void setCallAnalysisResponseSet(UriReference callAnalysisResponseSet) {
        this.callAnalysisResponseSet = callAnalysisResponseSet;
    }

    public Campaign errors(List<RestErrorDetail> errors) {
        this.errors = errors;
        return this;
    }

    @ApiModelProperty(example="null", value="a list of current error conditions associated with the campaign")
    @JsonProperty(value="errors")
    public List<RestErrorDetail> getErrors() {
        return this.errors;
    }

    public void setErrors(List<RestErrorDetail> errors) {
        this.errors = errors;
    }

    public Campaign callerName(String callerName) {
        this.callerName = callerName;
        return this;
    }

    @ApiModelProperty(example="null", value="caller id name to be displayed on the outbound call")
    @JsonProperty(value="callerName")
    public String getCallerName() {
        return this.callerName;
    }

    public void setCallerName(String callerName) {
        this.callerName = callerName;
    }

    public Campaign callerAddress(String callerAddress) {
        this.callerAddress = callerAddress;
        return this;
    }

    @ApiModelProperty(example="(555) 555-5555", value="caller id phone number to be displayed on the outbound call")
    @JsonProperty(value="callerAddress")
    public String getCallerAddress() {
        return this.callerAddress;
    }

    public void setCallerAddress(String callerAddress) {
        this.callerAddress = callerAddress;
    }

    public Campaign outboundLineCount(Integer outboundLineCount) {
        this.outboundLineCount = outboundLineCount;
        return this;
    }

    @ApiModelProperty(example="null", value="for agentless campaigns, the number of outbound lines to be concurrently dialed")
    @JsonProperty(value="outboundLineCount")
    public Integer getOutboundLineCount() {
        return this.outboundLineCount;
    }

    public void setOutboundLineCount(Integer outboundLineCount) {
        this.outboundLineCount = outboundLineCount;
    }

    public Campaign ruleSets(List<UriReference> ruleSets) {
        this.ruleSets = ruleSets;
        return this;
    }

    @ApiModelProperty(example="null", value="identifiers of the rule sets")
    @JsonProperty(value="ruleSets")
    public List<UriReference> getRuleSets() {
        return this.ruleSets;
    }

    public void setRuleSets(List<UriReference> ruleSets) {
        this.ruleSets = ruleSets;
    }

    public Campaign skipPreviewDisabled(Boolean skipPreviewDisabled) {
        this.skipPreviewDisabled = skipPreviewDisabled;
        return this;
    }

    @ApiModelProperty(example="null", value="for preview campaigns, indicator of whether the agent can skip a preview without placing a call")
    @JsonProperty(value="skipPreviewDisabled")
    public Boolean getSkipPreviewDisabled() {
        return this.skipPreviewDisabled;
    }

    public void setSkipPreviewDisabled(Boolean skipPreviewDisabled) {
        this.skipPreviewDisabled = skipPreviewDisabled;
    }

    public Campaign previewTimeOutSeconds(Long previewTimeOutSeconds) {
        this.previewTimeOutSeconds = previewTimeOutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="for preview campaigns, number of seconds before a call will be automatically placed. A value of 0 indicates no automatic placement of calls")
    @JsonProperty(value="previewTimeOutSeconds")
    public Long getPreviewTimeOutSeconds() {
        return this.previewTimeOutSeconds;
    }

    public void setPreviewTimeOutSeconds(Long previewTimeOutSeconds) {
        this.previewTimeOutSeconds = previewTimeOutSeconds;
    }

    public Campaign contactSort(ContactSort contactSort) {
        this.contactSort = contactSort;
        return this;
    }

    @ApiModelProperty(example="null", value="information determining the order in which the contacts will be dialed")
    @JsonProperty(value="contactSort")
    public ContactSort getContactSort() {
        return this.contactSort;
    }

    public void setContactSort(ContactSort contactSort) {
        this.contactSort = contactSort;
    }

    public Campaign noAnswerTimeout(Integer noAnswerTimeout) {
        this.noAnswerTimeout = noAnswerTimeout;
        return this;
    }

    @ApiModelProperty(example="null", value="for non-preview campaigns, how long to wait before dispositioning as 'no-answer', default 30 seconds")
    @JsonProperty(value="noAnswerTimeout")
    public Integer getNoAnswerTimeout() {
        return this.noAnswerTimeout;
    }

    public void setNoAnswerTimeout(Integer noAnswerTimeout) {
        this.noAnswerTimeout = noAnswerTimeout;
    }

    public Campaign callAnalysisLanguage(String callAnalysisLanguage) {
        this.callAnalysisLanguage = callAnalysisLanguage;
        return this;
    }

    @ApiModelProperty(example="null", value="The language the edge will use to analyse the call")
    @JsonProperty(value="callAnalysisLanguage")
    public String getCallAnalysisLanguage() {
        return this.callAnalysisLanguage;
    }

    public void setCallAnalysisLanguage(String callAnalysisLanguage) {
        this.callAnalysisLanguage = callAnalysisLanguage;
    }

    public Campaign priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of this campaign relative to other campaigns")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Campaign campaign = (Campaign)o;
        return Objects.equals(this.id, campaign.id) && Objects.equals(this.name, campaign.name) && Objects.equals(this.dateCreated, campaign.dateCreated) && Objects.equals(this.dateModified, campaign.dateModified) && Objects.equals(this.version, campaign.version) && Objects.equals(this.contactList, campaign.contactList) && Objects.equals(this.queue, campaign.queue) && Objects.equals((Object)this.dialingMode, (Object)campaign.dialingMode) && Objects.equals(this.script, campaign.script) && Objects.equals(this.edgeGroup, campaign.edgeGroup) && Objects.equals(this.campaignStatus, campaign.campaignStatus) && Objects.equals(this.phoneColumns, campaign.phoneColumns) && Objects.equals(this.abandonRate, campaign.abandonRate) && Objects.equals(this.dncLists, campaign.dncLists) && Objects.equals(this.callableTimeSet, campaign.callableTimeSet) && Objects.equals(this.callAnalysisResponseSet, campaign.callAnalysisResponseSet) && Objects.equals(this.errors, campaign.errors) && Objects.equals(this.callerName, campaign.callerName) && Objects.equals(this.callerAddress, campaign.callerAddress) && Objects.equals(this.outboundLineCount, campaign.outboundLineCount) && Objects.equals(this.ruleSets, campaign.ruleSets) && Objects.equals(this.skipPreviewDisabled, campaign.skipPreviewDisabled) && Objects.equals(this.previewTimeOutSeconds, campaign.previewTimeOutSeconds) && Objects.equals(this.contactSort, campaign.contactSort) && Objects.equals(this.noAnswerTimeout, campaign.noAnswerTimeout) && Objects.equals(this.callAnalysisLanguage, campaign.callAnalysisLanguage) && Objects.equals(this.priority, campaign.priority) && Objects.equals(this.selfUri, campaign.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.dateModified, this.version, this.contactList, this.queue, this.dialingMode, this.script, this.edgeGroup, this.campaignStatus, this.phoneColumns, this.abandonRate, this.dncLists, this.callableTimeSet, this.callAnalysisResponseSet, this.errors, this.callerName, this.callerAddress, this.outboundLineCount, this.ruleSets, this.skipPreviewDisabled, this.previewTimeOutSeconds, this.contactSort, this.noAnswerTimeout, this.callAnalysisLanguage, this.priority, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Campaign {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    contactList: ").append(this.toIndentedString(this.contactList)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    dialingMode: ").append(this.toIndentedString((Object)this.dialingMode)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    edgeGroup: ").append(this.toIndentedString(this.edgeGroup)).append("\n");
        sb.append("    campaignStatus: ").append(this.toIndentedString(this.campaignStatus)).append("\n");
        sb.append("    phoneColumns: ").append(this.toIndentedString(this.phoneColumns)).append("\n");
        sb.append("    abandonRate: ").append(this.toIndentedString(this.abandonRate)).append("\n");
        sb.append("    dncLists: ").append(this.toIndentedString(this.dncLists)).append("\n");
        sb.append("    callableTimeSet: ").append(this.toIndentedString(this.callableTimeSet)).append("\n");
        sb.append("    callAnalysisResponseSet: ").append(this.toIndentedString(this.callAnalysisResponseSet)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    callerName: ").append(this.toIndentedString(this.callerName)).append("\n");
        sb.append("    callerAddress: ").append(this.toIndentedString(this.callerAddress)).append("\n");
        sb.append("    outboundLineCount: ").append(this.toIndentedString(this.outboundLineCount)).append("\n");
        sb.append("    ruleSets: ").append(this.toIndentedString(this.ruleSets)).append("\n");
        sb.append("    skipPreviewDisabled: ").append(this.toIndentedString(this.skipPreviewDisabled)).append("\n");
        sb.append("    previewTimeOutSeconds: ").append(this.toIndentedString(this.previewTimeOutSeconds)).append("\n");
        sb.append("    contactSort: ").append(this.toIndentedString(this.contactSort)).append("\n");
        sb.append("    noAnswerTimeout: ").append(this.toIndentedString(this.noAnswerTimeout)).append("\n");
        sb.append("    callAnalysisLanguage: ").append(this.toIndentedString(this.callAnalysisLanguage)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DialingModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENTLESS("agentless"),
        PREVIEW("preview"),
        POWER("power"),
        PREDICTIVE("predictive"),
        PROGRESSIVE("progressive");

        private String value;

        private DialingModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DialingModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DialingModeEnum value : DialingModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DialingModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

