/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteGroupMembersRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteGroupRequest;
import com.mypurecloud.sdk.v2.api.request.GetFieldconfigRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupMembersRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupsSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PostGroupMembersRequest;
import com.mypurecloud.sdk.v2.api.request.PostGroupsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGroupsSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PutGroupRequest;
import com.mypurecloud.sdk.v2.model.Empty;
import com.mypurecloud.sdk.v2.model.FieldConfig;
import com.mypurecloud.sdk.v2.model.Group;
import com.mypurecloud.sdk.v2.model.GroupEntityListing;
import com.mypurecloud.sdk.v2.model.GroupMembersUpdate;
import com.mypurecloud.sdk.v2.model.GroupSearchRequest;
import com.mypurecloud.sdk.v2.model.GroupUpdate;
import com.mypurecloud.sdk.v2.model.GroupsSearchResponse;
import com.mypurecloud.sdk.v2.model.UserEntityListing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GroupsApi {
    private final ApiClient pcapiClient;

    public GroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteGroup(String groupId) throws ApiException {
        this.deleteGroupWithHttpInfo(groupId);
    }

    public ApiResponse<Void> deleteGroupWithHttpInfo(String groupId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling deleteGroup");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteGroup(DeleteGroupRequest request) throws ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteGroup(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public Empty deleteGroupMembers(String groupId, String ids) throws ApiException {
        return this.deleteGroupMembersWithHttpInfo(groupId, ids).getBody();
    }

    public ApiResponse<Empty> deleteGroupMembersWithHttpInfo(String groupId, String ids) throws ApiException {
        Object pclocalVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling deleteGroupMembers");
        }
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling deleteGroupMembers");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}/members".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "ids", ids));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Empty>(){});
    }

    public Empty deleteGroupMembers(DeleteGroupMembersRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Empty>(){});
    }

    public ApiResponse<Empty> deleteGroupMembers(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Empty>(){});
    }

    public FieldConfig getFieldconfig(String type) throws ApiException {
        return this.getFieldconfigWithHttpInfo(type).getBody();
    }

    public ApiResponse<FieldConfig> getFieldconfigWithHttpInfo(String type) throws ApiException {
        Object pclocalVarPostBody = null;
        if (type == null) {
            throw new ApiException(400, "Missing the required parameter 'type' when calling getFieldconfig");
        }
        String pclocalVarPath = "/api/v2/fieldconfig".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "type", type));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<FieldConfig>(){});
    }

    public FieldConfig getFieldconfig(GetFieldconfigRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<FieldConfig>(){});
    }

    public ApiResponse<FieldConfig> getFieldconfig(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<FieldConfig>(){});
    }

    public Group getGroup(String groupId) throws ApiException {
        return this.getGroupWithHttpInfo(groupId).getBody();
    }

    public ApiResponse<Group> getGroupWithHttpInfo(String groupId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroup");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Group>(){});
    }

    public Group getGroup(GetGroupRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Group>(){});
    }

    public ApiResponse<Group> getGroup(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Group>(){});
    }

    public UserEntityListing getGroupMembers(String groupId, Integer pageSize, Integer pageNumber, String sortOrder, List<String> expand) throws ApiException {
        return this.getGroupMembersWithHttpInfo(groupId, pageSize, pageNumber, sortOrder, expand).getBody();
    }

    public ApiResponse<UserEntityListing> getGroupMembersWithHttpInfo(String groupId, Integer pageSize, Integer pageNumber, String sortOrder, List<String> expand) throws ApiException {
        Object pclocalVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroupMembers");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}/members".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortOrder", sortOrder));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "expand", expand));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<UserEntityListing>(){});
    }

    public UserEntityListing getGroupMembers(GetGroupMembersRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<UserEntityListing>(){});
    }

    public ApiResponse<UserEntityListing> getGroupMembers(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<UserEntityListing>(){});
    }

    public GroupEntityListing getGroups(Integer pageSize, Integer pageNumber, String sortOrder) throws ApiException {
        return this.getGroupsWithHttpInfo(pageSize, pageNumber, sortOrder).getBody();
    }

    public ApiResponse<GroupEntityListing> getGroupsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortOrder) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/groups".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortOrder", sortOrder));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<GroupEntityListing>(){});
    }

    public GroupEntityListing getGroups(GetGroupsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<GroupEntityListing>(){});
    }

    public ApiResponse<GroupEntityListing> getGroups(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<GroupEntityListing>(){});
    }

    public GroupsSearchResponse getGroupsSearch(String q64, List<String> expand) throws ApiException {
        return this.getGroupsSearchWithHttpInfo(q64, expand).getBody();
    }

    public ApiResponse<GroupsSearchResponse> getGroupsSearchWithHttpInfo(String q64, List<String> expand) throws ApiException {
        Object pclocalVarPostBody = null;
        if (q64 == null) {
            throw new ApiException(400, "Missing the required parameter 'q64' when calling getGroupsSearch");
        }
        String pclocalVarPath = "/api/v2/groups/search".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "q64", q64));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "expand", expand));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<GroupsSearchResponse>(){});
    }

    public GroupsSearchResponse getGroupsSearch(GetGroupsSearchRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<GroupsSearchResponse>(){});
    }

    public ApiResponse<GroupsSearchResponse> getGroupsSearch(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<GroupsSearchResponse>(){});
    }

    public Empty postGroupMembers(String groupId, GroupMembersUpdate body) throws ApiException {
        return this.postGroupMembersWithHttpInfo(groupId, body).getBody();
    }

    public ApiResponse<Empty> postGroupMembersWithHttpInfo(String groupId, GroupMembersUpdate body) throws ApiException {
        GroupMembersUpdate pclocalVarPostBody = body;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling postGroupMembers");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postGroupMembers");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}/members".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Empty>(){});
    }

    public Empty postGroupMembers(PostGroupMembersRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Empty>(){});
    }

    public ApiResponse<Empty> postGroupMembers(ApiRequest<GroupMembersUpdate> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Empty>(){});
    }

    public Group postGroups(Group body) throws ApiException {
        return this.postGroupsWithHttpInfo(body).getBody();
    }

    public ApiResponse<Group> postGroupsWithHttpInfo(Group body) throws ApiException {
        Group pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postGroups");
        }
        String pclocalVarPath = "/api/v2/groups".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Group>(){});
    }

    public Group postGroups(PostGroupsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Group>(){});
    }

    public ApiResponse<Group> postGroups(ApiRequest<Group> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Group>(){});
    }

    public GroupsSearchResponse postGroupsSearch(GroupSearchRequest body) throws ApiException {
        return this.postGroupsSearchWithHttpInfo(body).getBody();
    }

    public ApiResponse<GroupsSearchResponse> postGroupsSearchWithHttpInfo(GroupSearchRequest body) throws ApiException {
        GroupSearchRequest pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postGroupsSearch");
        }
        String pclocalVarPath = "/api/v2/groups/search".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<GroupsSearchResponse>(){});
    }

    public GroupsSearchResponse postGroupsSearch(PostGroupsSearchRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<GroupsSearchResponse>(){});
    }

    public ApiResponse<GroupsSearchResponse> postGroupsSearch(ApiRequest<GroupSearchRequest> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<GroupsSearchResponse>(){});
    }

    public Group putGroup(String groupId, GroupUpdate body) throws ApiException {
        return this.putGroupWithHttpInfo(groupId, body).getBody();
    }

    public ApiResponse<Group> putGroupWithHttpInfo(String groupId, GroupUpdate body) throws ApiException {
        GroupUpdate pclocalVarPostBody = body;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling putGroup");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Group>(){});
    }

    public Group putGroup(PutGroupRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Group>(){});
    }

    public ApiResponse<Group> putGroup(ApiRequest<GroupUpdate> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Group>(){});
    }
}

