/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteGreetingRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingMediaRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGroupGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGroupGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.PostUserGreetingsRequest;
import com.mypurecloud.sdk.v2.api.request.PutGreetingRequest;
import com.mypurecloud.sdk.v2.api.request.PutGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.PutGroupGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.api.request.PutUserGreetingsDefaultsRequest;
import com.mypurecloud.sdk.v2.model.DefaultGreetingList;
import com.mypurecloud.sdk.v2.model.DomainEntityListing;
import com.mypurecloud.sdk.v2.model.Greeting;
import com.mypurecloud.sdk.v2.model.GreetingListing;
import com.mypurecloud.sdk.v2.model.GreetingMediaInfo;
import java.util.ArrayList;
import java.util.HashMap;

public class GreetingsApi {
    private final ApiClient pcapiClient;

    public GreetingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GreetingsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteGreeting(String greetingId) throws ApiException {
        this.deleteGreetingWithHttpInfo(greetingId);
    }

    public ApiResponse<Void> deleteGreetingWithHttpInfo(String greetingId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (greetingId == null) {
            throw new ApiException(400, "Missing the required parameter 'greetingId' when calling deleteGreeting");
        }
        String pclocalVarPath = "/api/v2/greetings/{greetingId}".replaceAll("\\{format\\}", "json").replaceAll("\\{greetingId\\}", this.pcapiClient.escapeString(greetingId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteGreeting(DeleteGreetingRequest request) throws ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteGreeting(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public Greeting getGreeting(String greetingId) throws ApiException {
        return this.getGreetingWithHttpInfo(greetingId).getBody();
    }

    public ApiResponse<Greeting> getGreetingWithHttpInfo(String greetingId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (greetingId == null) {
            throw new ApiException(400, "Missing the required parameter 'greetingId' when calling getGreeting");
        }
        String pclocalVarPath = "/api/v2/greetings/{greetingId}".replaceAll("\\{format\\}", "json").replaceAll("\\{greetingId\\}", this.pcapiClient.escapeString(greetingId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Greeting>(){});
    }

    public Greeting getGreeting(GetGreetingRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Greeting>(){});
    }

    public ApiResponse<Greeting> getGreeting(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Greeting>(){});
    }

    public GreetingMediaInfo getGreetingMedia(String greetingId, String formatId) throws ApiException {
        return this.getGreetingMediaWithHttpInfo(greetingId, formatId).getBody();
    }

    public ApiResponse<GreetingMediaInfo> getGreetingMediaWithHttpInfo(String greetingId, String formatId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (greetingId == null) {
            throw new ApiException(400, "Missing the required parameter 'greetingId' when calling getGreetingMedia");
        }
        String pclocalVarPath = "/api/v2/greetings/{greetingId}/media".replaceAll("\\{format\\}", "json").replaceAll("\\{greetingId\\}", this.pcapiClient.escapeString(greetingId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "formatId", formatId));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<GreetingMediaInfo>(){});
    }

    public GreetingMediaInfo getGreetingMedia(GetGreetingMediaRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<GreetingMediaInfo>(){});
    }

    public ApiResponse<GreetingMediaInfo> getGreetingMedia(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<GreetingMediaInfo>(){});
    }

    public DomainEntityListing getGreetings(Integer pageSize, Integer pageNumber) throws ApiException {
        return this.getGreetingsWithHttpInfo(pageSize, pageNumber).getBody();
    }

    public ApiResponse<DomainEntityListing> getGreetingsWithHttpInfo(Integer pageSize, Integer pageNumber) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/greetings".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DomainEntityListing>(){});
    }

    public DomainEntityListing getGreetings(GetGreetingsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DomainEntityListing>(){});
    }

    public ApiResponse<DomainEntityListing> getGreetings(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DomainEntityListing>(){});
    }

    public DefaultGreetingList getGreetingsDefaults() throws ApiException {
        return this.getGreetingsDefaultsWithHttpInfo().getBody();
    }

    public ApiResponse<DefaultGreetingList> getGreetingsDefaultsWithHttpInfo() throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/greetings/defaults".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList getGreetingsDefaults(GetGreetingsDefaultsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
    }

    public ApiResponse<DefaultGreetingList> getGreetingsDefaults(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DefaultGreetingList>(){});
    }

    public GreetingListing getGroupGreetings(String groupId, Integer pageSize, Integer pageNumber) throws ApiException {
        return this.getGroupGreetingsWithHttpInfo(groupId, pageSize, pageNumber).getBody();
    }

    public ApiResponse<GreetingListing> getGroupGreetingsWithHttpInfo(String groupId, Integer pageSize, Integer pageNumber) throws ApiException {
        Object pclocalVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroupGreetings");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}/greetings".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<GreetingListing>(){});
    }

    public GreetingListing getGroupGreetings(GetGroupGreetingsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<GreetingListing>(){});
    }

    public ApiResponse<GreetingListing> getGroupGreetings(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<GreetingListing>(){});
    }

    public DefaultGreetingList getGroupGreetingsDefaults(String groupId) throws ApiException {
        return this.getGroupGreetingsDefaultsWithHttpInfo(groupId).getBody();
    }

    public ApiResponse<DefaultGreetingList> getGroupGreetingsDefaultsWithHttpInfo(String groupId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroupGreetingsDefaults");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}/greetings/defaults".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList getGroupGreetingsDefaults(GetGroupGreetingsDefaultsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
    }

    public ApiResponse<DefaultGreetingList> getGroupGreetingsDefaults(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DefaultGreetingList>(){});
    }

    public DomainEntityListing getUserGreetings(String userId, Integer pageSize, Integer pageNumber) throws ApiException {
        return this.getUserGreetingsWithHttpInfo(userId, pageSize, pageNumber).getBody();
    }

    public ApiResponse<DomainEntityListing> getUserGreetingsWithHttpInfo(String userId, Integer pageSize, Integer pageNumber) throws ApiException {
        Object pclocalVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserGreetings");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/greetings".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DomainEntityListing>(){});
    }

    public DomainEntityListing getUserGreetings(GetUserGreetingsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DomainEntityListing>(){});
    }

    public ApiResponse<DomainEntityListing> getUserGreetings(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DomainEntityListing>(){});
    }

    public DefaultGreetingList getUserGreetingsDefaults(String userId) throws ApiException {
        return this.getUserGreetingsDefaultsWithHttpInfo(userId).getBody();
    }

    public ApiResponse<DefaultGreetingList> getUserGreetingsDefaultsWithHttpInfo(String userId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserGreetingsDefaults");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/greetings/defaults".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList getUserGreetingsDefaults(GetUserGreetingsDefaultsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
    }

    public ApiResponse<DefaultGreetingList> getUserGreetingsDefaults(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList postGreetings(Greeting body) throws ApiException {
        return this.postGreetingsWithHttpInfo(body).getBody();
    }

    public ApiResponse<DefaultGreetingList> postGreetingsWithHttpInfo(Greeting body) throws ApiException {
        Greeting pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postGreetings");
        }
        String pclocalVarPath = "/api/v2/greetings".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList postGreetings(PostGreetingsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
    }

    public ApiResponse<DefaultGreetingList> postGreetings(ApiRequest<Greeting> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DefaultGreetingList>(){});
    }

    public Greeting postGroupGreetings(String groupId, Greeting body) throws ApiException {
        return this.postGroupGreetingsWithHttpInfo(groupId, body).getBody();
    }

    public ApiResponse<Greeting> postGroupGreetingsWithHttpInfo(String groupId, Greeting body) throws ApiException {
        Greeting pclocalVarPostBody = body;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling postGroupGreetings");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postGroupGreetings");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}/greetings".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Greeting>(){});
    }

    public Greeting postGroupGreetings(PostGroupGreetingsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Greeting>(){});
    }

    public ApiResponse<Greeting> postGroupGreetings(ApiRequest<Greeting> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Greeting>(){});
    }

    public Greeting postUserGreetings(String userId, Greeting body) throws ApiException {
        return this.postUserGreetingsWithHttpInfo(userId, body).getBody();
    }

    public ApiResponse<Greeting> postUserGreetingsWithHttpInfo(String userId, Greeting body) throws ApiException {
        Greeting pclocalVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling postUserGreetings");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postUserGreetings");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/greetings".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Greeting>(){});
    }

    public Greeting postUserGreetings(PostUserGreetingsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Greeting>(){});
    }

    public ApiResponse<Greeting> postUserGreetings(ApiRequest<Greeting> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Greeting>(){});
    }

    public Greeting putGreeting(String greetingId, Greeting body) throws ApiException {
        return this.putGreetingWithHttpInfo(greetingId, body).getBody();
    }

    public ApiResponse<Greeting> putGreetingWithHttpInfo(String greetingId, Greeting body) throws ApiException {
        Greeting pclocalVarPostBody = body;
        if (greetingId == null) {
            throw new ApiException(400, "Missing the required parameter 'greetingId' when calling putGreeting");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putGreeting");
        }
        String pclocalVarPath = "/api/v2/greetings/{greetingId}".replaceAll("\\{format\\}", "json").replaceAll("\\{greetingId\\}", this.pcapiClient.escapeString(greetingId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Greeting>(){});
    }

    public Greeting putGreeting(PutGreetingRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Greeting>(){});
    }

    public ApiResponse<Greeting> putGreeting(ApiRequest<Greeting> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Greeting>(){});
    }

    public DefaultGreetingList putGreetingsDefaults(DefaultGreetingList body) throws ApiException {
        return this.putGreetingsDefaultsWithHttpInfo(body).getBody();
    }

    public ApiResponse<DefaultGreetingList> putGreetingsDefaultsWithHttpInfo(DefaultGreetingList body) throws ApiException {
        DefaultGreetingList pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putGreetingsDefaults");
        }
        String pclocalVarPath = "/api/v2/greetings/defaults".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList putGreetingsDefaults(PutGreetingsDefaultsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
    }

    public ApiResponse<DefaultGreetingList> putGreetingsDefaults(ApiRequest<DefaultGreetingList> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList putGroupGreetingsDefaults(String groupId, DefaultGreetingList body) throws ApiException {
        return this.putGroupGreetingsDefaultsWithHttpInfo(groupId, body).getBody();
    }

    public ApiResponse<DefaultGreetingList> putGroupGreetingsDefaultsWithHttpInfo(String groupId, DefaultGreetingList body) throws ApiException {
        DefaultGreetingList pclocalVarPostBody = body;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling putGroupGreetingsDefaults");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putGroupGreetingsDefaults");
        }
        String pclocalVarPath = "/api/v2/groups/{groupId}/greetings/defaults".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.pcapiClient.escapeString(groupId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList putGroupGreetingsDefaults(PutGroupGreetingsDefaultsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
    }

    public ApiResponse<DefaultGreetingList> putGroupGreetingsDefaults(ApiRequest<DefaultGreetingList> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList putUserGreetingsDefaults(String userId, DefaultGreetingList body) throws ApiException {
        return this.putUserGreetingsDefaultsWithHttpInfo(userId, body).getBody();
    }

    public ApiResponse<DefaultGreetingList> putUserGreetingsDefaultsWithHttpInfo(String userId, DefaultGreetingList body) throws ApiException {
        DefaultGreetingList pclocalVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling putUserGreetingsDefaults");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putUserGreetingsDefaults");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/greetings/defaults".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DefaultGreetingList>(){});
    }

    public DefaultGreetingList putUserGreetingsDefaults(PutUserGreetingsDefaultsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DefaultGreetingList>(){});
    }

    public ApiResponse<DefaultGreetingList> putUserGreetingsDefaults(ApiRequest<DefaultGreetingList> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DefaultGreetingList>(){});
    }
}

