/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.GetGeolocationsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserGeolocationRequest;
import com.mypurecloud.sdk.v2.api.request.PatchGeolocationsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchUserGeolocationRequest;
import com.mypurecloud.sdk.v2.model.Geolocation;
import com.mypurecloud.sdk.v2.model.GeolocationSettings;
import java.util.ArrayList;
import java.util.HashMap;

public class GeolocationApi {
    private final ApiClient pcapiClient;

    public GeolocationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GeolocationApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public GeolocationSettings getGeolocationsSettings() throws ApiException {
        return this.getGeolocationsSettingsWithHttpInfo().getBody();
    }

    public ApiResponse<GeolocationSettings> getGeolocationsSettingsWithHttpInfo() throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/geolocations/settings".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<GeolocationSettings>(){});
    }

    public GeolocationSettings getGeolocationsSettings(GetGeolocationsSettingsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<GeolocationSettings>(){});
    }

    public ApiResponse<GeolocationSettings> getGeolocationsSettings(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<GeolocationSettings>(){});
    }

    public Geolocation getUserGeolocation(String userId, String clientId) throws ApiException {
        return this.getUserGeolocationWithHttpInfo(userId, clientId).getBody();
    }

    public ApiResponse<Geolocation> getUserGeolocationWithHttpInfo(String userId, String clientId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserGeolocation");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling getUserGeolocation");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/geolocations/{clientId}".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString())).replaceAll("\\{clientId\\}", this.pcapiClient.escapeString(clientId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Geolocation>(){});
    }

    public Geolocation getUserGeolocation(GetUserGeolocationRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Geolocation>(){});
    }

    public ApiResponse<Geolocation> getUserGeolocation(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Geolocation>(){});
    }

    public GeolocationSettings patchGeolocationsSettings(GeolocationSettings body) throws ApiException {
        return this.patchGeolocationsSettingsWithHttpInfo(body).getBody();
    }

    public ApiResponse<GeolocationSettings> patchGeolocationsSettingsWithHttpInfo(GeolocationSettings body) throws ApiException {
        GeolocationSettings pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling patchGeolocationsSettings");
        }
        String pclocalVarPath = "/api/v2/geolocations/settings".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PATCH", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<GeolocationSettings>(){});
    }

    public GeolocationSettings patchGeolocationsSettings(PatchGeolocationsSettingsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<GeolocationSettings>(){});
    }

    public ApiResponse<GeolocationSettings> patchGeolocationsSettings(ApiRequest<GeolocationSettings> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<GeolocationSettings>(){});
    }

    public Geolocation patchUserGeolocation(String userId, String clientId, Geolocation body) throws ApiException {
        return this.patchUserGeolocationWithHttpInfo(userId, clientId, body).getBody();
    }

    public ApiResponse<Geolocation> patchUserGeolocationWithHttpInfo(String userId, String clientId, Geolocation body) throws ApiException {
        Geolocation pclocalVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling patchUserGeolocation");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling patchUserGeolocation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling patchUserGeolocation");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/geolocations/{clientId}".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString())).replaceAll("\\{clientId\\}", this.pcapiClient.escapeString(clientId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PATCH", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Geolocation>(){});
    }

    public Geolocation patchUserGeolocation(PatchUserGeolocationRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Geolocation>(){});
    }

    public ApiResponse<Geolocation> patchUserGeolocation(ApiRequest<Geolocation> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Geolocation>(){});
    }
}

