/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import java.io.File;

public class GitPathResolver {
    private static final char CANONICAL_PATH_SEPARATOR = '/';
    private final char nativePathSeparator;
    private final String repositoryRootDir;

    public GitPathResolver(String repositoryRootDir) {
        this(repositoryRootDir, File.separatorChar);
    }

    GitPathResolver(String repositoryRootDir, char nativePathSeparator) {
        this.repositoryRootDir = repositoryRootDir.charAt(repositoryRootDir.length() - 1) == nativePathSeparator ? repositoryRootDir : repositoryRootDir + nativePathSeparator;
        this.nativePathSeparator = nativePathSeparator;
    }

    String relativize(String absoluteNativePath) {
        if (!absoluteNativePath.startsWith(this.repositoryRootDir)) {
            throw new RuntimeException("Cannot relativize path '" + absoluteNativePath + "' to directory '" + this.repositoryRootDir + "'");
        }
        String result = absoluteNativePath.substring(this.repositoryRootDir.length());
        if (this.nativePathSeparator != '/') {
            result = result.replace(this.nativePathSeparator, '/');
        }
        return result;
    }

    public String relativize(File path) {
        return this.relativize(path.getAbsolutePath());
    }
}

