/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.config;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.IdRes;
import com.mxchip.config.ScaleTypeConfig;

public class DisplayConfig {
    private boolean mCacheOnDisc = true;
    private boolean mCacheInMemory = true;
    private Bitmap.Config mBitmapConfig = Bitmap.Config.RGB_565;
    private int mBackgroundColor = -1;
    private int mRadius = 0;
    private int mRadiusDirection = 4369;
    @IdRes
    private int mLoadingImageResId = -1;
    private Drawable mLoadingImageDrawable;
    @IdRes
    private int mLoadErrorImageResId = -1;
    private Drawable mLoadErrorImage;
    private ScaleTypeConfig mScaleType = ScaleTypeConfig.CenterCrop;
    private int mEffect = 0;
    private View mEffectOutputView;
    private float mThumbnail = 0.0f;
    private int mAnimationResId = -1;
    private int mGifLoopCount = 0;
    private boolean mIsGif = false;
    private int resizeWidth = 0;
    private int resizeHeight = 0;
    private boolean mPreLoad = false;
    private int mBlurRadius = 25;
    private int mBlurSample = 0;

    private DisplayConfig(Builder builder) {
        this.mCacheOnDisc = builder.mCacheOnDisc;
        this.mCacheInMemory = builder.mCacheInMemory;
        this.mBitmapConfig = builder.mBitmapConfig;
        this.mBackgroundColor = builder.mBackgroundColor;
        this.mRadius = builder.mRadius;
        this.mRadiusDirection = builder.mRadiusDirection;
        this.mLoadingImageResId = builder.mLoadingImageResId;
        this.mLoadingImageDrawable = builder.mLoadingImageDrawable;
        this.mLoadErrorImageResId = builder.mLoadErrorImageResId;
        this.mLoadErrorImage = builder.mLoadErrorImage;
        this.mScaleType = builder.mScaleType;
        this.mEffect = builder.mEffect;
        this.mEffectOutputView = builder.mEffectOutputView;
        this.mThumbnail = builder.mThumbnail;
        this.mAnimationResId = builder.mAnimationResId;
        this.mGifLoopCount = builder.mGifLoopCount;
        this.mIsGif = builder.mIsGif;
        this.resizeWidth = builder.resizeWidth;
        this.resizeHeight = builder.resizeHeight;
        this.mPreLoad = builder.mPreLoad;
        this.mBlurRadius = builder.mBlurRadius;
        this.mBlurSample = builder.mBlurSample;
    }

    public boolean isCacheOnDisc() {
        return this.mCacheOnDisc;
    }

    public boolean isCacheInMemory() {
        return this.mCacheInMemory;
    }

    public Bitmap.Config getBitmapConfig() {
        return this.mBitmapConfig;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
    }

    public int getRadius() {
        return this.mRadius;
    }

    public int getRadiusDirection() {
        return this.mRadiusDirection;
    }

    public int getLoadingImageResId() {
        return this.mLoadingImageResId;
    }

    public Drawable getLoadingImageDrawable() {
        return this.mLoadingImageDrawable;
    }

    public int getLoadErrorImageResId() {
        return this.mLoadErrorImageResId;
    }

    public Drawable getLoadErrorImage() {
        return this.mLoadErrorImage;
    }

    public ScaleTypeConfig getScaleType() {
        return this.mScaleType;
    }

    public int getEffect() {
        return this.mEffect;
    }

    public float getThumbnail() {
        return this.mThumbnail;
    }

    public int getAnimationResId() {
        return this.mAnimationResId;
    }

    public int getGifLoopCount() {
        return this.mGifLoopCount;
    }

    public boolean isGif() {
        return this.mIsGif;
    }

    public int getResizeWidth() {
        return this.resizeWidth;
    }

    public int getResizeHeight() {
        return this.resizeHeight;
    }

    public boolean isPreLoad() {
        return this.mPreLoad;
    }

    public int getBlurRadius() {
        return this.mBlurRadius;
    }

    public int getBlurSample() {
        return this.mBlurSample;
    }

    public View getEffectOutputView() {
        return this.mEffectOutputView;
    }

    public static class Builder {
        private boolean mCacheOnDisc = true;
        private boolean mCacheInMemory = true;
        private Bitmap.Config mBitmapConfig = Bitmap.Config.RGB_565;
        private int mBackgroundColor = -1;
        private int mRadius = 0;
        private int mRadiusDirection = 4369;
        @IdRes
        private int mLoadingImageResId = -1;
        private Drawable mLoadingImageDrawable;
        @IdRes
        private int mLoadErrorImageResId = -1;
        private Drawable mLoadErrorImage;
        private ScaleTypeConfig mScaleType = ScaleTypeConfig.CenterCrop;
        private int mEffect = 0;
        private View mEffectOutputView;
        private float mThumbnail = 0.0f;
        @IdRes
        private int mAnimationResId = -1;
        private int mGifLoopCount = 0;
        private boolean mIsGif = false;
        private int resizeWidth = 0;
        private int resizeHeight = 0;
        private boolean mPreLoad = false;
        private int mBlurRadius = 25;
        private int mBlurSample = 0;

        public Builder cacheOnDisc(boolean val) {
            this.mCacheOnDisc = val;
            return this;
        }

        public Builder cacheInMemory(boolean val) {
            this.mCacheInMemory = val;
            return this;
        }

        public Builder bitmapConfig(Bitmap.Config val) {
            this.mBitmapConfig = val;
            return this;
        }

        public Builder backgroundColor(int color) {
            this.mBackgroundColor = color;
            return this;
        }

        public Builder radius(int val) {
            this.mRadius = val;
            return this;
        }

        public Builder radiusDircetion(int direction) {
            this.mRadiusDirection = direction;
            return this;
        }

        public Builder loadingImageResId(@IdRes int resId) {
            this.mLoadingImageResId = resId;
            return this;
        }

        public Builder loadingImageDrawable(Drawable drawable) {
            this.mLoadingImageDrawable = drawable;
            return this;
        }

        public Builder loadErrorImageResId(@IdRes int loadErrorImageResId) {
            this.mLoadErrorImageResId = loadErrorImageResId;
            return this;
        }

        public Builder loadErrorImageDrawable(Drawable drawable) {
            this.mLoadErrorImage = drawable;
            return this;
        }

        public Builder scaleType(ScaleTypeConfig val) {
            this.mScaleType = val;
            return this;
        }

        public Builder effectOption(int effect) {
            this.mEffect = effect;
            return this;
        }

        public Builder effectOutputView(View view) {
            this.mEffectOutputView = view;
            return this;
        }

        public Builder thumbnail(float val) {
            this.mThumbnail = val;
            return this;
        }

        public Builder animationResId(@IdRes int val) {
            this.mAnimationResId = val;
            return this;
        }

        public Builder gifLoopCount(int val) {
            this.mGifLoopCount = val;
            return this;
        }

        public Builder isGif(boolean val) {
            this.mIsGif = val;
            return this;
        }

        public Builder resize(int width, int height) {
            this.resizeWidth = width;
            this.resizeHeight = height;
            return this;
        }

        public Builder isPreLoad(boolean val) {
            this.mPreLoad = val;
            return this;
        }

        public Builder blurRadius(int val) {
            this.mBlurRadius = val;
            return this;
        }

        public Builder blurSample(int val) {
            this.mBlurSample = val;
            return this;
        }

        public DisplayConfig build() {
            return new DisplayConfig(this);
        }
    }
}

