package com.mxchip.tool;

import android.content.Context;
import androidx.annotation.DrawableRes;
import android.widget.ImageView;

import com.mxchip.config.ImageConfig;
import com.mxchip.image_loader.base.BaseImageLoader;
import com.mxchip.interfaces.ImageLoadProcessInterface;

/**
 * 图片加载基础的工具类
 * Application
 * Created by hyj on 2019/4/19.
 */

public class ImageLoadBaseTool<T extends BaseImageLoader> {
    private static volatile ImageLoadBaseTool sImageLoadBaseTool = null;
    private T mImageLoader;

    public static ImageLoadBaseTool get() {
        if (sImageLoadBaseTool == null) {
            synchronized (ImageLoadBaseTool.class) {
                if (sImageLoadBaseTool == null) {
                    sImageLoadBaseTool = new ImageLoadBaseTool();
                }
            }
        }
        return sImageLoadBaseTool;
    }

    public void configImageLoader(Class<T> imageLoader) {
        try {
            mImageLoader = imageLoader.newInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configDefaultImageLoader() {
//        if (mImageLoader == null) {
//            mImageLoader = (T) new ImageLoadByGlide();
//            if (null == mImageLoader) return;
//        }
    }

    /**
     * imageView中加载项目内资源
     *
     * @param mContext
     * @param view
     * @param resId
     */
    public void display(Context mContext, final ImageView view, @DrawableRes int resId) {
        display(mContext, view, null, resId);

    }

    /**
     * 加载网络图片/本地图片
     *
     * @param mContext
     * @param view
     * @param url
     */
    public void display(Context mContext, ImageView view, String url) {

        display(mContext, view, url, -1);
    }

    /**
     * 加载图片
     *
     * @param mContext     上下文
     * @param view         imageview
     * @param url          图片地址
     * @param defaultImage 默认显示内容
     */
    public void display(Context mContext, ImageView view, String url, int defaultImage) {
        display(mContext, view, url, defaultImage, null);
    }

    /**
     * @param mContext
     * @param view
     * @param url
     * @param imageLoadProcessInterface
     */
    public void display(Context mContext, ImageView view, String url, ImageLoadProcessInterface imageLoadProcessInterface) {
        display(mContext, view, url, -1, imageLoadProcessInterface);
    }

    /**
     * @param mContext                  上下文
     * @param view                      imageview
     * @param url                       地址
     * @param defaultImage              默认图片
     * @param imageLoadProcessInterface 监听
     */
    public void display(Context mContext, ImageView view, String url, int defaultImage, ImageLoadProcessInterface imageLoadProcessInterface) {
        display(mContext, view, url, defaultImage, -1, imageLoadProcessInterface);
    }

    public void display(Context mContext, ImageView view, String url, int defaultImage, int failImage, ImageLoadProcessInterface imageLoadProcessInterface) {
        display(mContext, view, url, new ImageConfig(defaultImage, failImage, 0), imageLoadProcessInterface);
    }

    public void display(Context mContext, ImageView view, String url, ImageConfig config, ImageLoadProcessInterface imageLoadProcessInterface) {
        displayUrl(mContext, view, url, config, imageLoadProcessInterface);
    }

    /**
     * glide加载图片
     *
     * @param imageView view
     * @param url       url
     */
    private void displayUrl(Context mContext, final ImageView imageView, final String url, final ImageConfig config, final ImageLoadProcessInterface imageLoadProcessInterface) {
        configDefaultImageLoader();
        try {
            mImageLoader.display(mContext, imageView, url, config, imageLoadProcessInterface);
            System.out.println("imageloader -------> " + mImageLoader.getClass());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 恢复加载图片
     *
     * @param context
     */
    public void resumeLoad(Context context, String url) {
        if (mImageLoader != null) {
            mImageLoader.resumeLoad(context, url);
        }
    }

    /**
     * 清除一个资源的加载
     *
     * @param context
     */
    public void clearImageView(Context context, ImageView imageView, String url) {
        if (mImageLoader != null) {
            mImageLoader.clearImageView(context, imageView, url);
        }
    }

    /**
     * 暂停加载图片
     *
     * @param context
     */
    public void pauseLoad(Context context, String url) {
        if (mImageLoader != null) {
            mImageLoader.pauseLoad(context, url);
        }
    }
}