/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.tool;

import android.content.Context;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import com.mxchip.config.ImageConfig;
import com.mxchip.image_loader.base.BaseImageLoader;
import com.mxchip.interfaces.ImageLoadProcessInterface;

public class ImageLoadBaseTool<T extends BaseImageLoader> {
    private static volatile ImageLoadBaseTool sImageLoadBaseTool = null;
    private T mImageLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoadBaseTool get() {
        if (sImageLoadBaseTool != null) return sImageLoadBaseTool;
        Class<ImageLoadBaseTool> clazz = ImageLoadBaseTool.class;
        synchronized (ImageLoadBaseTool.class) {
            if (sImageLoadBaseTool != null) return sImageLoadBaseTool;
            sImageLoadBaseTool = new ImageLoadBaseTool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sImageLoadBaseTool;
        }
    }

    public void configImageLoader(Class<T> imageLoader) {
        try {
            this.mImageLoader = (BaseImageLoader)imageLoader.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configDefaultImageLoader() {
    }

    public void display(Context mContext, ImageView view, @DrawableRes int resId) {
        this.display(mContext, view, null, resId);
    }

    public void display(Context mContext, ImageView view, String url) {
        this.display(mContext, view, url, -1);
    }

    public void display(Context mContext, ImageView view, String url, int defaultImage) {
        this.display(mContext, view, url, defaultImage, null);
    }

    public void display(Context mContext, ImageView view, String url, ImageLoadProcessInterface imageLoadProcessInterface) {
        this.display(mContext, view, url, -1, imageLoadProcessInterface);
    }

    public void display(Context mContext, ImageView view, String url, int defaultImage, ImageLoadProcessInterface imageLoadProcessInterface) {
        this.display(mContext, view, url, defaultImage, -1, imageLoadProcessInterface);
    }

    public void display(Context mContext, ImageView view, String url, int defaultImage, int failImage, ImageLoadProcessInterface imageLoadProcessInterface) {
        this.display(mContext, view, url, new ImageConfig(defaultImage, failImage, 0), imageLoadProcessInterface);
    }

    public void display(Context mContext, ImageView view, String url, ImageConfig config, ImageLoadProcessInterface imageLoadProcessInterface) {
        this.displayUrl(mContext, view, url, config, imageLoadProcessInterface);
    }

    private void displayUrl(Context mContext, ImageView imageView, String url, ImageConfig config, ImageLoadProcessInterface imageLoadProcessInterface) {
        this.configDefaultImageLoader();
        try {
            this.mImageLoader.display(mContext, imageView, url, config, imageLoadProcessInterface);
            System.out.println("imageloader -------> " + this.mImageLoader.getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resumeLoad(Context context, String url) {
        if (this.mImageLoader != null) {
            this.mImageLoader.resumeLoad(context, url);
        }
    }

    public void clearImageView(Context context, ImageView imageView, String url) {
        if (this.mImageLoader != null) {
            this.mImageLoader.clearImageView(context, imageView, url);
        }
    }

    public void pauseLoad(Context context, String url) {
        if (this.mImageLoader != null) {
            this.mImageLoader.pauseLoad(context, url);
        }
    }
}

