/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.h2.tools.RunScript;
import org.h2.tools.Server;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.mule.munit.exception.DatabaseServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseServer {
    private static Logger logger = LoggerFactory.getLogger(DatabaseServer.class);
    private String database;
    private String sqlFile;
    private String csv;
    private Connection connection;
    private String connectionStringParameters;
    Server server;

    public DatabaseServer(String database, String sqlFile, String csv, String connectionStringParameters) {
        this.database = database;
        this.sqlFile = sqlFile;
        this.csv = csv;
        this.connectionStringParameters = connectionStringParameters;
    }

    public void start() {
        try {
            logger.info("Starting database server...");
            this.addJdbcToClassLoader();
            this.sanitizeDatabaseName();
            String connectionString = this.getConnectionString();
            this.connection = DriverManager.getConnection(connectionString);
            this.server = Server.createTcpServer((String[])new String[0]).start();
            this.executeQueriesFromSQLFile(this.connection);
            Statement stmt = this.connection.createStatement();
            this.createTablesFromCsv(stmt);
        }
        catch (Exception e) {
            throw new DatabaseServerException("Could not start the database server", (Throwable)e);
        }
    }

    private void sanitizeDatabaseName() {
        this.database = StringUtils.substringBefore((String)StringUtils.trim((String)this.database), (String)";");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean execute(String sql) {
        try (Statement statement = this.connection.createStatement();){
            Boolean bl = statement.execute(sql);
            return bl;
        }
        catch (SQLException e) {
            logger.error("There has been a problem while executing the SQL statement", (Throwable)e);
            throw new DatabaseServerException("There has been a problem while executing the SQL statement", (Throwable)e);
        }
    }

    public List<Map<String, String>> executeQuery(String sql) {
        try {
            return this.getMap(sql);
        }
        catch (SQLException e) {
            logger.error("There has been a problem while executing the SQL statement", (Throwable)e);
            throw new DatabaseServerException("There has been a problem while executing the SQL statement", (Throwable)e);
        }
    }

    public void validateThat(String query, String returns) {
        try {
            Writer writerQueryResult = this.getResults(query);
            String expected = returns.replace("\\n", "\n");
            String actual = writerQueryResult.toString().trim();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (ComparisonFailure e) {
            throw new AssertionError((Object)e.getMessage());
        }
        catch (ClassCastException ccException) {
            throw new DatabaseServerException("The JSON String must always be an array");
        }
        catch (SQLException e) {
            throw new DatabaseServerException("Invalid Query");
        }
        catch (IOException e) {
            throw new DatabaseServerException("Could no access to query results");
        }
    }

    public void stop() {
        logger.info("Stopping database server ...");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not stop the database server", e);
        }
    }

    private void addJdbcToClassLoader() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class.forName("org.h2.Driver").newInstance();
    }

    private void executeQueriesFromSQLFile(Connection conn) throws SQLException, FileNotFoundException {
        if (this.sqlFile != null) {
            logger.info("Loading " + this.sqlFile + " ...");
            InputStream streamImput = this.getClass().getClassLoader().getResourceAsStream(this.sqlFile);
            if (streamImput != null) {
                RunScript.execute((Connection)conn, (Reader)new InputStreamReader(streamImput));
            } else {
                throw new RuntimeException("The SQL file " + this.sqlFile + " could not be found");
            }
        }
    }

    private void createTablesFromCsv(Statement stmt) {
        if (this.csv != null) {
            logger.info("Loading " + this.csv + " ...");
            String[] tables = this.csv.split(";");
            boolean isCaseSensitive = this.isDatabaseToUpperParameterSet(this.connectionStringParameters);
            for (String table : tables) {
                String tableName = table.replaceAll(".csv", "");
                try {
                    StringBuilder command = new StringBuilder();
                    command.append("CREATE TABLE `" + tableName + "` AS SELECT * FROM CSVREAD('classpath:" + table + "'");
                    if (isCaseSensitive) {
                        command.append(", null, 'caseSensitiveColumnNames=true'");
                    }
                    command.append(");");
                    stmt.execute(command.toString());
                }
                catch (SQLException e) {
                    throw new RuntimeException("Could not create table " + tableName + " from " + table + " : " + e.getCause(), e);
                }
            }
        }
    }

    private boolean isDatabaseToUpperParameterSet(String connectionStringParameters) {
        String[] parameters = StringUtils.split((String)connectionStringParameters, (char)';');
        if (parameters != null) {
            for (String parameter : parameters) {
                if (!StringUtils.containsIgnoreCase((CharSequence)parameter, (CharSequence)"DATABASE_TO_UPPER") || !StringUtils.containsIgnoreCase((CharSequence)parameter, (CharSequence)"FALSE")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private List<Map<String, String>> getMap(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Writer getResults(String sql) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getConnectionString() {
        String connectionString = "jdbc:h2:mem:" + this.database;
        if (StringUtils.isNotBlank((CharSequence)this.connectionStringParameters)) {
            connectionString = connectionString + ";" + this.connectionStringParameters;
        }
        logger.debug("Connection string: " + connectionString);
        return connectionString;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }
}

