/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mojo;

import java.util.List;

import org.apache.maven.plugin.logging.Log;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.CoverageAuthorizator;
import org.mule.munit.plugin.maven.runner.printer.ResultPrinter;
import org.mule.munit.plugin.maven.util.DefaultResultPrinterFactory;
import org.mule.munit.runner.printer.CoverageSummaryPrinter;

/**
 * <p>
 * Returns the result printers based on the user configuration
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class ApplicationResultPrinterFactory extends DefaultResultPrinterFactory {

  private Coverage coverage;
  private boolean enableCoverageReport;


  public ApplicationResultPrinterFactory(Log log) {
    super(log);
  }

  public ApplicationResultPrinterFactory withCoverageSummaryReport(Coverage coverage, String runtimeProduct) {
    this.coverage = coverage;
    this.enableCoverageReport = new CoverageAuthorizator(coverage, runtimeProduct).shouldRunCoverage();
    return this;
  }

  @Override
  public List<ResultPrinter> create() {
    List<ResultPrinter> printers = super.create();

    if (enableCoverageReport) {
      printers.add(0, new CoverageSummaryPrinter(log, coverage));
    }
    return printers;
  }

}
