/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.coverage;

import org.apache.maven.plugin.logging.Log;
import org.mule.munit.remote.coverage.printer.ConsolePrinter;

/**
 * A console printer that prints output through the Maven Log
 * 
 * @author Mulesoft Inc.
 * @since 2.1.0
 */
public class MavenConsolePrinter extends ConsolePrinter {

  private Log log;

  public MavenConsolePrinter(Log log) {
    this.log = log;
  }

  @Override
  public void log(String message) {
    log.info(message);
  }
}
