/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.printer;

import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.Coverage;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.printer.ResultPrinter;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.remote.coverage.model.ApplicationCoverageReport;
import org.mule.munit.remote.coverage.model.MuleFlow;
import org.mule.munit.remote.coverage.model.MuleResource;

public class CoverageSummaryPrinter
implements ResultPrinter {
    private Double requiredApplicationCoverage = 1.0;
    private Double requiredResourceCoverage = -1.0;
    private Double requiredFlowCoverage = -1.0;
    private Boolean failBuild = false;
    private final Log log;

    public CoverageSummaryPrinter(Log log, Coverage coverage) {
        this.log = log;
        this.requiredApplicationCoverage = coverage.getRequiredApplicationCoverage();
        this.requiredResourceCoverage = coverage.getRequiredResourceCoverage();
        this.requiredFlowCoverage = coverage.getRequiredFlowCoverage();
        this.failBuild = coverage.getFailBuild();
    }

    public void print(TargetProduct targetProduct, RunResult result) {
        if (!result.getApplicationCoverageReport().isPresent()) {
            this.log.warn((CharSequence)"Coverage Report will not be printed. No coverage data found");
            return;
        }
        ApplicationCoverageReport report = (ApplicationCoverageReport)result.getApplicationCoverageReport().get();
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)"MUnit Coverage Summary");
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)(" * Resources: " + report.getResources().size() + " - Flows: " + report.getApplicationFlowCount() + " - Processors: " + report.getApplicationMessageProcessorCount()));
        if (report.getApplicationFlowCount() > 0) {
            this.log.info((CharSequence)(" * Application Coverage: " + this.formatCoverage(report.getCoverage()) + "%"));
        } else {
            this.log.info((CharSequence)" * Application Coverage: N/A");
        }
        this.printCoverageWarnings(report);
    }

    private String formatCoverage(Double coverage) {
        DecimalFormat formatter = new DecimalFormat("#00.00");
        return formatter.format(coverage);
    }

    private void printCoverageWarnings(ApplicationCoverageReport report) {
        block10: {
            ArrayList<String> warnings = new ArrayList<String>();
            if (this.requiredApplicationCoverage != -1.0 && report.getApplicationFlowCount() > 0 && report.getCoverage() < this.requiredApplicationCoverage) {
                warnings.add(" * Application coverage is below defined limit. Required: " + this.requiredApplicationCoverage + "% - Current: " + this.formatCoverage(report.getCoverage()) + "%");
            }
            if (this.requiredResourceCoverage != -1.0) {
                for (MuleResource mr : report.getResources()) {
                    if (mr.getCoverage() == -1.0 || !(mr.getCoverage() < this.requiredResourceCoverage)) continue;
                    warnings.add(" * Resource " + mr.getName() + " coverage is below defined limit. Required: " + this.requiredResourceCoverage + "% - Current: " + this.formatCoverage(mr.getCoverage()) + "%");
                }
            }
            if (this.requiredFlowCoverage != -1.0) {
                for (MuleResource mr : report.getResources()) {
                    for (MuleFlow mf : mr.getFlows()) {
                        if (!(mf.getCoverage() < this.requiredFlowCoverage)) continue;
                        warnings.add(" * Flow: " + mr.getName() + " -> " + mf.getName() + " coverage is below defined limit. Required: " + this.requiredFlowCoverage + "% - Current: " + this.formatCoverage(mf.getCoverage()) + "%");
                    }
                }
            }
            if (warnings.isEmpty()) break block10;
            this.log.info((CharSequence)"");
            if (!this.failBuild.booleanValue()) {
                this.log.warn((CharSequence)"----------------------------- WARNING --------------------------------------");
                for (String w : warnings) {
                    this.log.warn((CharSequence)w);
                }
            } else {
                this.log.error((CharSequence)"------------------------------ FAILURE ---------------------------------------");
                for (String w : warnings) {
                    this.log.error((CharSequence)w);
                }
            }
        }
    }
}

