/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.munit.Coverage;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.coverage.CoverageAuthorizator;
import org.mule.munit.plugin.maven.runner.model.Debugger;
import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.runtime.Product;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.plugin.maven.util.BaseApplicationRunConfigurationFactory;
import org.mule.munit.remote.MinMuleVersionConfig;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.DebuggerConfiguration;
import org.mule.munit.remote.api.configuration.EmbeddedContainerConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.configuration.ServerPluginConfiguration;

public class ApplicationRunConfigurationFactory
extends BaseApplicationRunConfigurationFactory {
    private static final Logger LOGGER = LogManager.getLogger(ApplicationRunConfigurationFactory.class);
    private final Coverage coverage;
    private final String pluginVersion;
    private final boolean shouldRunCoverage;
    private final Debugger debugger;
    private final String port;

    public ApplicationRunConfigurationFactory(Log log, String munitTest, String munitTags, Boolean skipAfterFailure, TargetProduct targetRuntime, WorkingDirectoryGenerator workingDirectoryGenerator, File munitSrcFolder, Coverage coverage, Debugger debugger, String pluginVersion, MavenProject project, MavenSession session, Boolean clearParameters, String port, String runToken, List<String> mmvs, MinMuleVersionConfig minMuleVersionConfig, String runtimeLocalDistribution) {
        super(log, project.getArtifactId(), munitTest, munitTags, skipAfterFailure, targetRuntime, workingDirectoryGenerator, munitSrcFolder, project, session, clearParameters, mmvs, minMuleVersionConfig, runtimeLocalDistribution);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pluginVersion), (String)"The pluginVersion must not be null nor empty");
        this.coverage = coverage;
        this.pluginVersion = pluginVersion;
        this.shouldRunCoverage = new CoverageAuthorizator(coverage, targetRuntime.getProduct().name()).shouldRunCoverage();
        this.debugger = Optional.ofNullable(debugger).orElseGet(() -> Debugger.fromString(null));
        this.port = port;
        this.runToken = runToken != null ? runToken : this.runToken;
    }

    protected RunConfiguration.RunConfigurationBuilder getRunConfigurationBuilder() throws MojoExecutionException {
        RunConfiguration.RunConfigurationBuilder builder = super.getRunConfigurationBuilder();
        return builder.withCoverageConfiguration(this.buildCoverageConfiguration(this.shouldRunCoverage)).withDebuggerConfiguration(this.buildDebuggerConfiguration());
    }

    protected String getSocketPort() {
        return this.port;
    }

    protected ContainerConfiguration.ContainerConfigurationBuilder getContainerConfigurationBuilder() {
        EmbeddedContainerConfiguration.EmbeddedContainerConfigurationBuilder builder = (EmbeddedContainerConfiguration.EmbeddedContainerConfigurationBuilder)super.getContainerConfigurationBuilder();
        if (this.shouldRunCoverage) {
            ServerPluginConfiguration coveragePluginConfiguration = this.getCoverageServerPluginConfiguration(this.pluginVersion);
            builder.withServerPluginConfiguration(coveragePluginConfiguration);
        }
        if (this.debugger.getAddDebugger().booleanValue()) {
            if (this.getTargetProduct().getProduct() != Product.MULE_EE) {
                LOGGER.info("mule-dx-debugger requires MULE_EE product, current product: {}, the debugger plugin will not be added", (Object)this.getTargetProduct().getProduct());
            } else {
                builder.withServerPluginConfiguration(this.getDebuggerPluginConfiguration(this.debugger.getDebuggerVersion()));
            }
        }
        return builder;
    }

    private CoverageConfiguration buildCoverageConfiguration(Boolean shouldRunCoverage) {
        Set coverageIgnoreFlows = this.coverage != null ? this.coverage.getIgnoreFlows() : Collections.emptySet();
        Set coverageIgnoreFiles = this.coverage != null ? this.coverage.getIgnoreFiles() : Collections.emptySet();
        Optional<Integer> coverageServerTimeout = this.coverage != null ? Optional.ofNullable(this.coverage.getServerTimeout()) : Optional.empty();
        CoverageConfiguration.CoverageConfigurationBuilder coverageConfiguration = new CoverageConfiguration.CoverageConfigurationBuilder().withShouldRunCoverage(shouldRunCoverage).withSuitePaths(this.locateMunitTestSuitesToRun()).withIgnoredFiles(coverageIgnoreFiles).withIgnoredFlowNames(coverageIgnoreFlows);
        coverageServerTimeout.ifPresent(arg_0 -> ((CoverageConfiguration.CoverageConfigurationBuilder)coverageConfiguration).withCoverageServerTimeout(arg_0));
        return coverageConfiguration.build();
    }

    private DebuggerConfiguration buildDebuggerConfiguration() {
        if (this.getTargetProduct().getProduct() != Product.MULE_EE || !this.debugger.getAddDebugger().booleanValue()) {
            return null;
        }
        return new DebuggerConfiguration(this.debugger.getDebuggerPort(), this.debugger.getLockId(), this.debugger.getLockTries());
    }

    private ServerPluginConfiguration getCoverageServerPluginConfiguration(String coveragePluginVersion) {
        return new ServerPluginConfiguration.ServerPluginConfigurationBuilder().withGroupId("com.mulesoft.munit.plugins").withArtifactId("munit-coverage-plugin").withVersion(coveragePluginVersion).withClassifier("mule-server-plugin").withType("jar").build();
    }

    private ServerPluginConfiguration getDebuggerPluginConfiguration(String debuggerPluginVersion) {
        return new ServerPluginConfiguration.ServerPluginConfigurationBuilder().withGroupId("com.mulesoft").withArtifactId("mule-dx-mule-debugger").withVersion(debuggerPluginVersion).withType("jar").withClassifier("mule-server-plugin").build();
    }
}

