/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.CoverageAuthorizator;
import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.plugin.maven.util.BaseCloudHubRunConfigurationFactory;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.tools.model.Deployment;

public class CloudHubRunConfigurationFactory
extends BaseCloudHubRunConfigurationFactory {
    private final Coverage coverage;
    private final boolean shouldRunCoverage;

    public CloudHubRunConfigurationFactory(Log log, String munitTest, String munitTags, Boolean skipAfterFailure, TargetProduct targetProduct, WorkingDirectoryGenerator workingDirectoryGenerator, File munitSrcFolder, Coverage coverage, String pluginVersion, MavenProject project, MavenSession session, Deployment deployment, Map<String, String> systemPropertyVariables, Map<String, String> environmentVariables, String executionId, boolean clearParameters) {
        super(log, project.getArtifactId(), munitTest, munitTags, skipAfterFailure, targetProduct, workingDirectoryGenerator, munitSrcFolder, project, session, deployment, systemPropertyVariables, environmentVariables, executionId, Boolean.valueOf(clearParameters));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pluginVersion), (Object)"The pluginVersion must not be null nor empty");
        this.coverage = coverage;
        this.shouldRunCoverage = new CoverageAuthorizator(coverage, targetProduct.getProduct().name()).shouldRunCoverage();
    }

    protected RunConfiguration.RunConfigurationBuilder getRunConfigurationBuilder() throws MojoExecutionException {
        RunConfiguration.RunConfigurationBuilder builder = super.getRunConfigurationBuilder();
        return builder.withCoverageConfiguration(this.buildCoverageConfiguration(this.shouldRunCoverage));
    }

    private CoverageConfiguration buildCoverageConfiguration(Boolean shouldRunCoverage) {
        Set coverageIgnoreFlows = this.coverage != null ? this.coverage.getIgnoreFlows() : Collections.emptySet();
        Set coverageIgnoreFiles = this.coverage != null ? this.coverage.getIgnoreFiles() : Collections.emptySet();
        CoverageConfiguration coverageConfiguration = new CoverageConfiguration.CoverageConfigurationBuilder().withShouldRunCoverage(shouldRunCoverage).withSuitePaths(this.locateMunitTestSuitesToRun()).withIgnoredFiles(coverageIgnoreFiles).withIgnoredFlowNames(coverageIgnoreFlows).build();
        return coverageConfiguration;
    }
}

