/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.printer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.runner.printer.ResultPrinter;

public abstract class FileResultPrinter
implements ResultPrinter {
    protected File reportBasePath;
    protected Log log;

    public FileResultPrinter(File reportBasePath, Log log) {
        this.reportBasePath = reportBasePath;
        this.log = log;
    }

    public PrintStream getResultPrintStream(String fileName) throws FileNotFoundException, UnsupportedEncodingException {
        File file = new File(this.reportBasePath, fileName);
        this.createFolderIfNotExists(file.getParentFile());
        return new PrintStream((OutputStream)new FileOutputStream(file), false, StandardCharsets.UTF_8.name());
    }

    private void createFolderIfNotExists(File parentFile) throws FileNotFoundException {
        boolean success = true;
        if (!parentFile.exists()) {
            success = parentFile.mkdirs();
        }
        if (!success) {
            throw new FileNotFoundException("Unable to create directory " + parentFile);
        }
    }
}

