/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mojo;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.CoverageAuthorizator;
import org.mule.munit.runner.printer.CoverageSummaryPrinter;
import org.mule.munit.runner.printer.MavenResultPrinter;
import org.mule.munit.runner.printer.ResultPrinter;
import org.mule.munit.runner.printer.TestOutputFilePrinter;
import org.mule.munit.runner.printer.TextResultFilePrinter;
import org.mule.munit.runner.printer.XmlResultPrinter;

public class ResultPrinterFactory {
    private Log log;
    private File testOutputDirectory;
    private File surefireReportsFolder;
    private Map<String, String> systemProperties;
    private Coverage coverage;
    private boolean enableSurefireReports;
    private boolean redirectTestOutputToFile;
    private boolean enableCoverageReport;

    public ResultPrinterFactory(Log log) {
        this.log = log;
    }

    public ResultPrinterFactory withSurefireReports(Boolean enableSurefireReports, File surefireReportsFolder, Map<String, String> systemProperties) {
        this.surefireReportsFolder = surefireReportsFolder;
        this.enableSurefireReports = enableSurefireReports;
        this.systemProperties = systemProperties;
        return this;
    }

    public ResultPrinterFactory withTestOutputReports(Boolean redirectTestOutputToFile, File testOutputDirectory) {
        Preconditions.checkNotNull((Object)redirectTestOutputToFile, (Object)"Redirect Output to File property cannot be null");
        Preconditions.checkNotNull((Object)testOutputDirectory, (Object)"Test Output Directory cannot be null");
        this.redirectTestOutputToFile = redirectTestOutputToFile;
        this.testOutputDirectory = testOutputDirectory;
        return this;
    }

    public ResultPrinterFactory withCoverageSummaryReport(Coverage coverage, String runtimeProduct) {
        this.coverage = coverage;
        this.enableCoverageReport = new CoverageAuthorizator(coverage, runtimeProduct).shouldRunCoverage();
        return this;
    }

    public List<ResultPrinter> create() {
        ArrayList<ResultPrinter> printers = new ArrayList<ResultPrinter>();
        if (this.enableCoverageReport) {
            printers.add(new CoverageSummaryPrinter(this.log, this.coverage));
        }
        printers.add(new MavenResultPrinter(this.log));
        if (this.enableSurefireReports) {
            printers.addAll(this.getSurefireResultPrinters(this.redirectTestOutputToFile));
        }
        if (this.redirectTestOutputToFile) {
            printers.add(new TestOutputFilePrinter(this.testOutputDirectory, this.log));
        }
        return printers;
    }

    private List<ResultPrinter> getSurefireResultPrinters(Boolean redirectTestOutputToFile) {
        ArrayList<ResultPrinter> printers = new ArrayList<ResultPrinter>();
        printers.add(new XmlResultPrinter(this.surefireReportsFolder, this.systemProperties, this.log));
        printers.add(new TextResultFilePrinter(this.surefireReportsFolder, this.log));
        if (redirectTestOutputToFile.booleanValue()) {
            printers.add(new TestOutputFilePrinter(this.surefireReportsFolder, this.log));
        }
        return printers;
    }
}

