/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runner.printer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.mule.runner.model.RunResult;
import org.mule.runner.printer.FileResultPrinter;

public class TestOutputPrinter
extends FileResultPrinter {
    private static final String TXT_REPORT_HEADER = "munit.";

    public TestOutputPrinter(File reportBasePath, File suitesBasePath, File projectBasePath, Log log) {
        super(reportBasePath, suitesBasePath, projectBasePath, log);
    }

    public void print(RunResult runResult) {
        Map<String, List<String>> suiteOutputs = runResult.getSuiteOutputs();
        try {
            for (Map.Entry<String, List<String>> suiteOutput : suiteOutputs.entrySet()) {
                String suiteRelativePath = this.getSuiteRelativePath(suiteOutput.getKey());
                String suiteReportName = suiteRelativePath.replace("/", ".");
                suiteReportName = suiteReportName.replace(".xml", "-output.txt");
                PrintStream out = this.getResultPrintStream(TXT_REPORT_HEADER + suiteReportName);
                this.log.debug((CharSequence)String.format("Writing %s file in %s", suiteReportName, this.reportBasePath));
                for (String outputLine : suiteOutput.getValue()) {
                    out.println(outputLine);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

