/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runner.model;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.runner.model.SuiteResult;
import org.mule.runner.model.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunResult {
    private String token;
    private SuiteResult currentSuite = null;
    private long currentSuiteTime;
    private long currentTestTime;
    private ApplicationCoverageReport coverageReport;
    private Map<String, List<String>> suiteOutputs;
    private boolean runFinished = false;
    private boolean coverageEnabled = true;
    private Map<String, SuiteResult> suites = new HashMap<String, SuiteResult>();

    public void runStarted(String token) {
        this.token = token;
    }

    public void testSuiteStartFailed(String suiteFullPath, String stackTrace) {
        SuiteResult suite = new SuiteResult();
        suite.setRuntimeStartFailed(true);
        suite.setCause(stackTrace);
        suite.setSuiteFinished(true);
        suite.setSuitePath(suiteFullPath);
        this.suites.put(suiteFullPath, suite);
        suite.setTime(0L);
    }

    public void testSuiteStarted(String suiteFullPath) {
        SuiteResult suite = new SuiteResult();
        suite.setSuitePath(suiteFullPath);
        this.suites.put(suiteFullPath, suite);
        this.currentSuite = suite;
        this.currentSuiteTime = System.currentTimeMillis();
    }

    public void testStarted(String suiteFullPath, String testName) {
        this.suites.get(suiteFullPath).add(testName, new TestResult(testName));
        this.currentTestTime = System.currentTimeMillis();
    }

    public void setNumberOfTests(String suiteFullPath, Integer numberTests) {
        this.suites.get(suiteFullPath).setNumberOfTests(numberTests);
    }

    public void testFailure(String suiteFullPath, String testName, String stackTrace) {
        TestResult test = this.suites.get(suiteFullPath).getTest(testName);
        test.setFailed(true);
        test.setCause(stackTrace);
        test.setTime(System.currentTimeMillis() - this.currentTestTime);
    }

    public void testError(String suiteFullPath, String testName, String stackTrace) {
        TestResult test = this.suites.get(suiteFullPath).getTest(testName);
        test.setError(true);
        test.setCause(stackTrace);
        test.setTime(System.currentTimeMillis() - this.currentTestTime);
    }

    public void testFinished(String suiteFullPath, String testName) {
        TestResult test = this.suites.get(suiteFullPath).getTest(testName);
        test.setFinished(true);
        test.setTime(System.currentTimeMillis() - this.currentTestTime);
    }

    public void testIgnored(String suiteFullPath, String testName) {
        TestResult test = this.suites.get(suiteFullPath).getTest(testName);
        test.setIgnored(true);
        test.setTime(System.currentTimeMillis() - this.currentTestTime);
    }

    public void suiteFinished(String suiteFullPath) {
        this.suites.get(suiteFullPath).setSuiteFinished(true);
        this.currentSuite = null;
        this.suites.get(suiteFullPath).setTime(System.currentTimeMillis() - this.currentSuiteTime);
    }

    public void suiteFailure(String suiteFullPath, String stackTrace) {
        this.suites.get(suiteFullPath).setSuiteFailed(true);
        this.suites.get(suiteFullPath).setCause(stackTrace);
        this.currentSuite = null;
        this.suites.get(suiteFullPath).setTime(System.currentTimeMillis() - this.currentSuiteTime);
    }

    public void suiteError(String suiteFullPath, String stackTrace) {
        this.suites.get(suiteFullPath).setSuiteError(true);
        this.suites.get(suiteFullPath).setCause(stackTrace);
        this.currentSuite = null;
        this.suites.get(suiteFullPath).setTime(System.currentTimeMillis() - this.currentSuiteTime);
    }

    public Collection<SuiteResult> getSuites() {
        return this.suites.values();
    }

    public boolean isRunFinished() {
        return this.runFinished;
    }

    public void setRunFinished(boolean runFinished) {
        this.runFinished = runFinished;
    }

    public SuiteResult getSuite(String suiteName) {
        return this.suites.get(suiteName);
    }

    public int getNumberOfTests() {
        int tests = 0;
        for (SuiteResult suite : this.getSuites()) {
            tests += suite.getNumberOfTests();
        }
        return tests;
    }

    public int getProcessedTests() {
        int processedTests = 0;
        for (SuiteResult suite : this.getSuites()) {
            processedTests += suite.getNumberOfProcessedTests();
        }
        return processedTests;
    }

    public int getNumberOfIgnores() {
        int ignores = 0;
        for (SuiteResult suite : this.getSuites()) {
            ignores += suite.getNumberOfIgnores();
        }
        return ignores;
    }

    public int getNumberOfErrors() {
        int errors = 0;
        for (SuiteResult suite : this.getSuites()) {
            errors += suite.getNumberOfErrors();
        }
        return errors;
    }

    public int getNumberOfFailures() {
        int failures = 0;
        for (SuiteResult suite : this.getSuites()) {
            failures += suite.getNumberOfFailures();
        }
        return failures;
    }

    public String getToken() {
        return this.token;
    }

    public SuiteResult getCurrentSuite() {
        return this.currentSuite;
    }

    public ApplicationCoverageReport getApplicationCoverageReport() {
        return this.coverageReport;
    }

    public void setCoverageReport(String jsonReport) {
        this.coverageReport = (ApplicationCoverageReport)new Gson().fromJson(jsonReport, ApplicationCoverageReport.class);
    }

    public Map<String, List<String>> getSuiteOutputs() {
        return this.suiteOutputs;
    }

    public void setSuiteOutputs(Map<String, List<String>> suiteOutputs) {
        this.suiteOutputs = suiteOutputs;
    }

    public boolean hasFailed() {
        for (SuiteResult suite : this.suites.values()) {
            if (!suite.hasFailed() && !suite.hasError()) continue;
            return true;
        }
        return false;
    }

    public void setCoverageEnabled(boolean runCoverage) {
        this.coverageEnabled = runCoverage;
    }

    public boolean isCoverageEnabled() {
        return this.coverageEnabled;
    }
}

