/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runner.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.runner.handler.RunnerMessageHandler;
import org.mule.runner.model.RunResult;
import org.mule.runner.model.SuiteResult;

public class TestOutputMessageHandler
implements RunnerMessageHandler {
    private Map<String, List<String>> suiteOutputs = new HashMap<String, List<String>>();
    private List<String> suiteOutput = new ArrayList<String>();
    private String currentSuite;
    private Log log;

    public TestOutputMessageHandler(Log log) {
        this.log = log;
    }

    public void handleSuiteFinished(SuiteResult suiteResult) {
        this.suiteOutputs.put(suiteResult.getSuitePath(), new ArrayList<String>(this.suiteOutput));
        this.printTestSuiteFinished(suiteResult);
        this.currentSuite = null;
    }

    public void handleSuiteStartFailure(SuiteResult suiteResult) {
        this.printTestSuiteStartFailed(FilenameUtils.getName((String)suiteResult.getSuitePath()), suiteResult.getCause());
        this.suiteOutputs.put(suiteResult.getSuitePath(), Arrays.asList(suiteResult.getCause()));
        this.currentSuite = null;
    }

    public void handleSuiteStart(String suiteFullPath) {
        this.printTestSuiteStart(FilenameUtils.getName((String)suiteFullPath));
        this.suiteOutput.clear();
        this.currentSuite = suiteFullPath;
    }

    public void handleStandardOutputLine(String message) {
        if (this.shouldPrintDebugLine()) {
            System.out.println(message);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currentSuite)) {
            this.suiteOutput.add(message);
        }
    }

    public void handleRunResult(RunResult runResult) {
        runResult.setSuiteOutputs(this.suiteOutputs);
    }

    public void handleSuiteFailure(SuiteResult suiteResult) {
        this.handleSuiteErrorOrFailure(suiteResult, "ERROR");
    }

    public void handleSuiteError(SuiteResult suiteResult) {
        this.handleSuiteErrorOrFailure(suiteResult, "FAILURE");
    }

    protected void handleSuiteErrorOrFailure(SuiteResult suiteResult, String tag) {
        this.printTestSuiteFailedOrError(FilenameUtils.getName((String)suiteResult.getSuitePath()), suiteResult.getCause(), tag);
        this.suiteOutput.add(suiteResult.getCause());
        this.suiteOutputs.put(suiteResult.getSuitePath(), new ArrayList<String>(this.suiteOutput));
        this.currentSuite = null;
    }

    private boolean shouldPrintDebugLine() {
        return this.currentSuite == null && this.log.isDebugEnabled();
    }

    private void printTestSuiteStart(String suiteName) {
        System.out.format("Running %s\n", suiteName);
    }

    private void printTestSuiteFinished(SuiteResult suiteResult) {
        System.out.format("Tests run: %d, Failures: %d, Errors: %d, Skipped: %d, Time elapsed: %.3f sec\n", suiteResult.getNumberOfTests(), suiteResult.getNumberOfFailures(), suiteResult.getNumberOfErrors(), suiteResult.getNumberOfIgnores(), Float.valueOf((float)suiteResult.getTime() / 1000.0f));
    }

    private void printTestSuiteStartFailed(String suiteName, String cause) {
        System.out.format("%s failed to start\n", suiteName);
        System.out.println(cause);
    }

    private void printTestSuiteFailedOrError(String suiteName, String cause, String tag) {
        System.out.format("%s failed <<< %s\n", suiteName, tag);
        System.out.println(cause);
    }
}

