/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.model;

import java.io.Serializable;
import java.util.Optional;
import org.mule.munit.plugins.coverage.core.model.CoverageTypedComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.LocationPart;

public class CoverageLocationPart
implements LocationPart,
Serializable {
    private static final long serialVersionUID = 5757545892752260058L;
    private String partPath;
    private String fileName;
    private Integer lineInFile;
    private CoverageTypedComponentIdentifier partIdentifier;

    public CoverageLocationPart(String partPath, Optional<CoverageTypedComponentIdentifier> partIdentifier, Optional<String> fileName, Optional<Integer> lineInFile) {
        this.partPath = partPath;
        this.partIdentifier = partIdentifier.orElse(null);
        fileName.ifPresent(configFileName -> {
            this.fileName = configFileName;
        });
        lineInFile.ifPresent(line -> {
            this.lineInFile = line;
        });
    }

    public String getPartPath() {
        return this.partPath;
    }

    public Optional<TypedComponentIdentifier> getPartIdentifier() {
        return Optional.ofNullable(this.partIdentifier);
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public Optional<Integer> getLineInFile() {
        return Optional.ofNullable(this.lineInFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoverageLocationPart that = (CoverageLocationPart)o;
        if (!this.getPartPath().equals(that.getPartPath())) {
            return false;
        }
        if (this.getPartIdentifier() != null ? !this.getPartIdentifier().equals(that.getPartIdentifier()) : that.getPartIdentifier() != null) {
            return false;
        }
        if (this.getFileName() != null ? !this.getFileName().equals(that.getFileName()) : that.getFileName() != null) {
            return false;
        }
        return this.getLineInFile() != null ? this.getLineInFile().equals(that.getLineInFile()) : that.getLineInFile() == null;
    }

    public int hashCode() {
        int result = this.getPartPath().hashCode();
        result = 31 * result + (this.getPartIdentifier() != null ? this.getPartIdentifier().hashCode() : 0);
        result = 31 * result + (this.getFileName() != null ? this.getFileName().hashCode() : 0);
        result = 31 * result + (this.getLineInFile() != null ? this.getLineInFile().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CoverageLocationPart{partPath='" + this.partPath + '\'' + ", partIdentifier=" + this.partIdentifier + ", fileName='" + this.fileName + '\'' + ", lineInFile=" + this.lineInFile + '}';
    }

    public static CoverageLocationPart fromLocationPart(LocationPart lp) {
        return new CoverageLocationPart(lp.getPartPath(), CoverageTypedComponentIdentifier.fromTypedComponentIdentifier(lp.getPartIdentifier()), lp.getFileName(), lp.getLineInFile());
    }
}

