/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.printer;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.CoverageLimits;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleLocation;
import org.mule.munit.plugins.coverage.report.model.MuleResource;
import org.mule.munit.plugins.coverage.report.printer.CoverageReportPrinter;
import org.mule.munit.plugins.coverage.report.printer.model.sonar.SonarCoverage;
import org.mule.munit.plugins.coverage.report.printer.model.sonar.SonarFile;
import org.mule.munit.plugins.coverage.report.printer.model.sonar.SonarLineToCover;

public class SonarPrinter
implements CoverageReportPrinter {
    public static final String PRINTER_NAME = "SONAR";
    private static final String MULESOFT_FLOWS = "src/main/mule";
    private final File reportFile;
    private CoverageLimits coverageLimits;

    public SonarPrinter(CoverageLimits coverageLimits, File reportDirectory) {
        Preconditions.checkNotNull((Object)coverageLimits, (Object)"Coverage limits cannot be null");
        Preconditions.checkNotNull((Object)reportDirectory, (Object)"Report directory cannot be null");
        this.coverageLimits = coverageLimits;
        this.reportFile = reportDirectory;
    }

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    @Override
    public void printReport(ApplicationCoverageReport report) {
        try {
            XStream xStream = new XStream();
            xStream.autodetectAnnotations(true);
            SonarCoverage sonarCoverage = new SonarCoverage();
            for (MuleResource mr : report.getResources()) {
                SonarFile sonarFile = new SonarFile(new File(MULESOFT_FLOWS, mr.getName()).getPath());
                sonarCoverage.addFile(sonarFile);
                for (MuleFlow flow : mr.getFlows()) {
                    for (MuleLocation location : flow.getCoveredLocations()) {
                        SonarLineToCover sonarLineToCover = new SonarLineToCover(location.getLineNumber(), true);
                        sonarFile.addLineToCover(sonarLineToCover);
                    }
                    List coveredLocations = flow.getCoveredLocations().stream().map(x -> x.getLineNumber()).collect(Collectors.toList());
                    for (MuleLocation location : flow.getLocations()) {
                        if (coveredLocations.contains(location.getLineNumber())) continue;
                        SonarLineToCover sonarLineToCover = new SonarLineToCover(location.getLineNumber(), false);
                        sonarFile.addLineToCover(sonarLineToCover);
                    }
                }
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile), StandardCharsets.UTF_8);
            writer.write(xStream.toXML((Object)sonarCoverage));
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

