/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.server;

import java.io.IOException;
import java.io.ObjectInputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.gson.Gson;


// TODO do we need an specific class fot this?
/**
 * Deserialize the {@link CoverageLocations} and send it to a {@link CoverageLocationsAccumulator}
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class CoverageMessageParser implements Runnable {

  private transient Log log = LogFactory.getLog(this.getClass());

  private ObjectInputStream in;
  private CoverageLocationsAccumulator coverageLocationsAccumulator;

  public CoverageMessageParser(ObjectInputStream in, CoverageLocationsAccumulator coverageLocationsAccumulator) {
    this.in = in;
    this.coverageLocationsAccumulator = coverageLocationsAccumulator;
  }

  @Override
  public void run() {
    try {
      String message = (String) in.readObject();
      CoverageLocations report = new Gson().fromJson(message, CoverageLocations.class);
      accumulateClientReport(report);
    } catch (ClassNotFoundException e) {
      log.error("Fail to deserialize coverage report when received.", e);
    } catch (IOException ioException) {
      log.debug("Coverage connection closed.");
    } finally {
      try {
        if (null != in) {
          in.close();
        }
      } catch (IOException e) {
        log.debug("Fail to release Coverage server client connection resources.");
      }
    }
  }

  private void accumulateClientReport(CoverageLocations report) {
    coverageLocationsAccumulator.accumulateCoverageLocations(report);
  }
}
