/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.server;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.server.CoverageLocations;
import org.mule.munit.plugins.coverage.server.CoverageLocationsAccumulator;

public class CoverageMessageParser
implements Runnable {
    private transient Log log = LogFactory.getLog(this.getClass());
    private ObjectInputStream in;
    private CoverageLocationsAccumulator coverageLocationsAccumulator;

    public CoverageMessageParser(ObjectInputStream in, CoverageLocationsAccumulator coverageLocationsAccumulator) {
        this.in = in;
        this.coverageLocationsAccumulator = coverageLocationsAccumulator;
    }

    @Override
    public void run() {
        try {
            String message = (String)this.in.readObject();
            CoverageLocations report = (CoverageLocations)new Gson().fromJson(message, CoverageLocations.class);
            this.accumulateClientReport(report);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)"Fail to deserialize coverage report when received.", (Throwable)e);
        }
        catch (IOException ioException) {
            this.log.debug((Object)"Coverage connection closed.");
        }
        finally {
            try {
                if (null != this.in) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                this.log.debug((Object)"Fail to release Coverage server client connection resources.");
            }
        }
    }

    private void accumulateClientReport(CoverageLocations report) {
        this.coverageLocationsAccumulator.accumulateCoverageLocations(report);
    }
}

