/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.path.PathParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageCalculator {
    private transient Log log = LogFactory.getLog(this.getClass());
    private Set<String> coveredPaths;
    private Set<String> flows;
    private Set<String> subFlows;
    private Set<String> batches;

    public CoverageCalculator(Set<String> coveredPaths, Set<String> flows, Set<String> subFlows, Set<String> batches) {
        this.coveredPaths = coveredPaths;
        this.flows = flows;
        this.subFlows = subFlows;
        this.batches = batches;
        this.countParentAsCovered();
    }

    public CoverageResult calculate() {
        HashMap<String, Count> pathPerFlow = new HashMap<String, Count>();
        this.countFlowPaths(pathPerFlow);
        this.countSubFlowPaths(pathPerFlow);
        this.countBatchPaths(pathPerFlow);
        int totalPathCount = this.flows.size() + this.subFlows.size() + this.batches.size();
        Double contextCoverage = this.percentage(this.coveredPaths.size(), totalPathCount);
        HashMap<String, Double> containersCoverage = new HashMap<String, Double>();
        for (Map.Entry count : pathPerFlow.entrySet()) {
            containersCoverage.put((String)count.getKey(), this.percentage(((Count)count.getValue()).coveredMp, ((Count)count.getValue()).totalMp));
        }
        this.log.debug((Object)("Coverage Calculations --> Covered Paths: " + this.coveredPaths.size() + " - Total Paths: " + totalPathCount + " - Context Coverage: " + contextCoverage));
        return new CoverageResult(contextCoverage, containersCoverage);
    }

    private void countFlowPaths(Map<String, Count> pathPerFlow) {
        this.countPaths(pathPerFlow, this.flows, "processors");
    }

    private void countSubFlowPaths(Map<String, Count> pathPerFlow) {
        this.countPaths(pathPerFlow, this.subFlows, "subprocessors");
    }

    private void countBatchPaths(Map<String, Count> pathPerFlow) {
        this.countPaths(pathPerFlow, this.batches, "input", "process-records", "on-complete");
    }

    private void countPaths(Map<String, Count> pathPerFLow, Set<String> paths, String ... tokens) {
        ArrayList<String> tokenFlags = new ArrayList<String>();
        for (String token : tokens) {
            tokenFlags.add("/" + token);
        }
        for (String path : paths) {
            this.countPath(path, pathPerFLow, tokenFlags);
        }
    }

    private void countPath(String path, Map<String, Count> pathPerFlow, List<String> tokenFlags) {
        String containerName = this.buildContainerName(path, tokenFlags);
        if (!pathPerFlow.containsKey(containerName)) {
            pathPerFlow.put(containerName, new Count());
        }
        Count count = pathPerFlow.get(containerName);
        ++count.totalMp;
        if (this.coveredPaths.contains(path)) {
            ++count.coveredMp;
        }
    }

    private String buildContainerName(String path, List<String> tokenFlags) {
        for (String tokenFlag : tokenFlags) {
            int tokenIdx = path.indexOf(tokenFlag);
            if (tokenIdx == -1) continue;
            return path.substring(0, tokenIdx);
        }
        return null;
    }

    private double percentage(int part, int total) {
        if (total != 0) {
            return (double)part * 100.0 / (double)total;
        }
        return 0.0;
    }

    private void countParentAsCovered() {
        HashSet<String> coveredParentPaths = new HashSet<String>();
        for (String cp : this.coveredPaths) {
            String parentPath = PathParser.getParentPath(cp);
            if (!StringUtils.isNotBlank((String)parentPath) || !this.flows.contains(parentPath) && !this.subFlows.contains(parentPath) && !this.batches.contains(parentPath)) continue;
            coveredParentPaths.add(parentPath);
        }
        this.coveredPaths.addAll(coveredParentPaths);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CoverageResult {
        private final Double coverage;
        private final Map<String, Double> containersCoverage;

        public CoverageResult(Double coverage, Map<String, Double> containersCoverage) {
            this.coverage = coverage;
            this.containersCoverage = containersCoverage;
        }

        public Double getCoverage() {
            return this.coverage;
        }

        public Map<String, Double> getContainersCoverage() {
            return this.containersCoverage;
        }
    }

    private static class Count {
        int totalMp;
        int coveredMp;

        private Count() {
        }
    }
}

