/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageCalculator {
    private Set<String> coveredPaths;
    private Set<String> flows;
    private Set<String> subFlows;
    private Set<String> batches;

    public CoverageCalculator(Set<String> coveredPaths, Set<String> flows, Set<String> subFlows, Set<String> batches) {
        this.coveredPaths = coveredPaths;
        this.flows = flows;
        this.subFlows = subFlows;
        this.batches = batches;
    }

    public CoverageResult calculate() {
        HashMap<String, Count> pathPerFlow = new HashMap<String, Count>();
        this.countFlowPaths(pathPerFlow);
        this.countSubFlowPaths(pathPerFlow);
        this.countBatchPaths(pathPerFlow);
        Double coverage = this.percentage(this.coveredPaths.size(), this.flows.size() + this.subFlows.size() + this.batches.size());
        HashMap<String, Double> containersCoverage = new HashMap<String, Double>();
        for (Map.Entry count : pathPerFlow.entrySet()) {
            containersCoverage.put((String)count.getKey(), this.percentage(((Count)count.getValue()).coveredMp, ((Count)count.getValue()).totalMp));
        }
        return new CoverageResult(coverage, containersCoverage);
    }

    private void countFlowPaths(Map<String, Count> pathPerFlow) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add("/processors");
        for (String path : this.flows) {
            this.countPath(path, pathPerFlow, tokens);
        }
    }

    private void countSubFlowPaths(Map<String, Count> pathPerFlow) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add("/subprocessors");
        for (String path : this.subFlows) {
            this.countPath(path, pathPerFlow, tokens);
        }
    }

    private void countBatchPaths(Map<String, Count> pathPerFlow) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add("/input");
        tokens.add("/process-records");
        tokens.add("/on-complete");
        for (String path : this.batches) {
            this.countPath(path, pathPerFlow, tokens);
        }
    }

    private void countPath(String path, Map<String, Count> pathPerFlow, List<String> tokenFlags) {
        String containerName = this.buildContainerName(path, tokenFlags);
        if (!pathPerFlow.containsKey(containerName)) {
            pathPerFlow.put(containerName, new Count());
        }
        Count count = pathPerFlow.get(containerName);
        ++count.totalMp;
        if (this.coveredPaths.contains(path)) {
            ++count.coveredMp;
        }
    }

    private String buildContainerName(String path, List<String> tokenFlags) {
        String containerName = null;
        for (String tokenFlag : tokenFlags) {
            try {
                containerName = path.substring(0, path.indexOf(tokenFlag));
                break;
            }
            catch (IndexOutOfBoundsException e) {
            }
        }
        return containerName;
    }

    private double percentage(int size, int size1) {
        if (size1 != 0) {
            return (double)size / (double)size1 * 100.0;
        }
        return 0.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CoverageResult {
        private final Double coverage;
        private final Map<String, Double> containersCoverage;

        public CoverageResult(Double coverage, Map<String, Double> containersCoverage) {
            this.coverage = coverage;
            this.containersCoverage = containersCoverage;
        }

        public Double getCoverage() {
            return this.coverage;
        }

        public Map<String, Double> getContainersCoverage() {
            return this.containersCoverage;
        }
    }

    private static class Count {
        int totalMp;
        int coveredMp;

        private Count() {
        }
    }
}

