/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.mock;

import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.model.Answer;
import org.mule.munit.common.model.Attribute;
import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.FlowName;
import org.mule.munit.mock.MockModule;
import org.mule.munit.tools.mock.AfterCall;
import org.mule.munit.tools.mock.BeforeCall;
import org.mule.munit.tools.mock.StreamingUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class MockOperations {
    @Inject
    private Registry registry;
    private MockModule mockModule = new MockModule();

    @Summary(value="Mock the Processor when it matches processor name and attributes")
    public void mockWhen(@Example(value="http:request") String processor, @Optional @Expression(value=ExpressionSupport.NOT_SUPPORTED) List<Attribute> withAttributes, @ParameterGroup(name="Answer") Answer answer, StreamingHelper streamingHelper) {
        Event thenReturn = answer.getThenReturn();
        FlowName thenCall = answer.getThenCall();
        this.mockModule.setRegistry(this.registry);
        if (thenCall != null) {
            this.mockModule.when(processor, withAttributes, thenCall);
        } else {
            this.validateErrorInEvent(thenReturn);
            StreamingUtils.resolveCursorProviders(streamingHelper, thenReturn);
            this.mockModule.when(processor, withAttributes, thenReturn);
        }
    }

    @Summary(value="Verify that a processor is called")
    public void verifyCall(@Example(value="mule:logger") String processor, @Optional @Expression(value=ExpressionSupport.NOT_SUPPORTED) List<Attribute> withAttributes, @Optional Integer times, @Optional Integer atLeast, @Optional Integer atMost) {
        if (null == times && null == atLeast && null == atMost) {
            times = 1;
        }
        this.mockModule.setRegistry(this.registry);
        this.mockModule.verifyCall(processor, withAttributes, times, atLeast, atMost);
    }

    @Summary(value="Allows to take actions over the event before and after the execution of a processor")
    public void spy(String processor, @Optional @NullSafe @Expression(value=ExpressionSupport.NOT_SUPPORTED) List<Attribute> withAttributes, @Optional BeforeCall beforeCall, @Optional AfterCall afterCall, RouterCompletionCallback callback) {
        this.mockModule.setRegistry(this.registry);
        this.mockModule.spy(processor, withAttributes, beforeCall == null ? null : beforeCall.getChain(), afterCall == null ? null : afterCall.getChain());
        callback.success(Result.builder().build());
    }

    protected void setRegistry(Registry registry) {
        this.registry = registry;
    }

    protected void setMockModule(MockModule mockModule) {
        this.mockModule = mockModule;
    }

    private void validateErrorInEvent(Event thenReturn) {
        if (thenReturn != null && thenReturn.getError() != null && StringUtils.isNotBlank((CharSequence)thenReturn.getError().getTypeId()) && thenReturn.getError().getCause() != null) {
            throw new IllegalArgumentException("Mocked event's error failure. The attributes typeId and cause are mutually exclusive. Please define only one of them");
        }
    }
}

