/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.util.queue.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.munit.runner.component.rules.TestDescription;
import org.mule.munit.runner.component.rules.TestRule;
import org.mule.munit.tools.util.queue.internal.error.QueueTimeOutException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.core.api.util.queue.DefaultQueueConfiguration;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;

public class TemporaryQueueRule
implements TestRule,
Initialisable {
    public static final String DEFAULT_QUEUE_NAME = "MUNIT_TOOLS_QUEUE";
    @Inject
    @Named(value="_muleQueueManager")
    protected QueueManager queueManager;
    private static final AtomicReference<QueueManager> queueManagerReference = new AtomicReference();
    private static final AtomicReference<Map<String, Queue>> queuesReference = new AtomicReference();
    private final Map<String, Queue> queues = new HashMap<String, Queue>();

    public void apply(TestDescription testDescription) {
        this.clearQueues();
    }

    public void push(Serializable value, String queueName) {
        this.executeOnQueue(TemporaryQueueRule.getQueueName(queueName), queue -> {
            queue.put(value);
            return null;
        });
    }

    public Serializable pop(String queueName, Long timeOut) {
        if (Objects.isNull(timeOut)) {
            return this.executeOnQueue(TemporaryQueueRule.getQueueName(queueName), Queue::take);
        }
        return this.executeOnQueue(TemporaryQueueRule.getQueueName(queueName), queue -> queue.poll(timeOut.longValue()));
    }

    public static synchronized int size(String queueName) {
        return TemporaryQueueRule.executeOnQueue(queueManagerReference.get(), queuesReference.get(), TemporaryQueueRule.getQueueName(queueName), Queue::size);
    }

    public synchronized void reset() {
        this.clearQueues();
    }

    private void clearQueues() {
        this.queues.keySet().forEach(q -> this.executeOnQueue((String)q, queue -> {
            queue.clear();
            return null;
        }));
    }

    private static <T> T executeOnQueue(QueueManager queueManager, Map<String, Queue> queues, String queueName, TemporaryQueueTask<T> task) {
        try {
            Queue queue = TemporaryQueueRule.getOrCreateQueue(queueManager, queues, queueName);
            return task.run(queue);
        }
        catch (InterruptedException e) {
            throw new QueueTimeOutException(e, queueName);
        }
    }

    private static Queue getOrCreateQueue(QueueManager queueManager, Map<String, Queue> queues, String queueName) {
        Queue queue = queues.get(queueName);
        if (queue == null) {
            queueManager.setQueueConfiguration(queueName, (QueueConfiguration)new DefaultQueueConfiguration());
            queue = queueManager.getQueueSession().getQueue(queueName);
            queues.put(queueName, queue);
        }
        return queue;
    }

    private <T> T executeOnQueue(String queue, TemporaryQueueTask<T> task) {
        return TemporaryQueueRule.executeOnQueue(this.queueManager, this.queues, queue, task);
    }

    private static String getQueueName(String queueName) {
        return queueName != null ? queueName : DEFAULT_QUEUE_NAME;
    }

    public void initialise() {
        queueManagerReference.set(this.queueManager);
        queuesReference.set(this.queues);
    }

    @FunctionalInterface
    private static interface TemporaryQueueTask<T> {
        public T run(Queue var1) throws InterruptedException;
    }
}

