/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.munit.common.model.EventAttributes;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.UntypedEventError;
import org.mule.munit.common.model.Variable;
import org.mule.munit.runner.processors.EnableFlowSources;
import org.mule.munit.runner.processors.SetEventProcessor;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class MunitExtensionLoadingDelegate
implements ExtensionLoadingDelegate {
    private static final String VERSION = "2.3.7";
    private static final String DESCRIPTION = "MUnit: Core components";
    private static final String NAME = "MUnit";
    private static final String VENDOR = "MuleSoft, Inc.";
    private static final MuleVersion MIN_MULE_VERSION = new MuleVersion("4.1.0");
    private static final String PREFIX = "munit";
    private static final String NAMESPACE = "http://www.mulesoft.org/schema/mule/munit";
    private static final String SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/munit/current/mule-munit.xsd";
    private static final String SCHEMA_VERSION = "2.3.7";
    private static final String XSD_FILE_NAME = "mule-munit.xsd";
    private static final String CONFIG_NAME = "config";
    private static final String CONFIG_DESCRIPTION = "MUnit configuration";
    private static final String CONFIG_MIN_MULE_VERSION = "minMuleVersion";
    private static final String CONFIG_MIN_MULE_VERSION_DESCRIPTION = "Minimum Mule Version to run suite against";
    private static final String CONFIG_REQUIRED_PRODUCT = "requiredProduct";
    private static final String CONFIG_REQUIRED_PRODUCT_DESCRIPTION = "Runtime product to run suite against";
    private static final String CONFIG_IGNORE = "ignore";
    private static final String CONFIG_IGNORE_DESCRIPTION = "Ignore suite";
    private static final String PARAMETERIZATIONS_NAME = "parameterizations";
    private static final String PARAMETERIZATIONS_FILE = "file";
    private static final String PARAMETERIZATION_NAME = "parameterization";
    private static final String PARAMETERIZATION_CLASS_NAME = "org.mule.munit.runner.processors.Parameterization";
    private static final String PARAMETERS_NAME = "parameters";
    private static final String PARAMETER_NAME = "parameter";
    private static final String PARAMETER_CLASS_NAME = "org.mule.munit.runner.processors.Parameter";
    private static final String PARAMETERS_PROPERTY_NAME_FIELD = "propertyName";
    private static final String PARAMETERS_VALUE_FIELD = "value";
    private static final String PARAMETERIZATION_NAME_FIELD = "name";
    private static final String DYNAMIC_PORT_NAME = "dynamic-port";
    private static final String DYNAMIC_PORT_DESCRIPTION = "Dynamic Port Property";
    private static final String PROPERTY_NAME_NAME = "propertyName";
    private static final String PROPERTY_NAME_DESCRIPTION = "Name of the property for the dynamic port";
    private static final String MIN_NAME = "min";
    private static final String MIN_DESCRIPTION = "Minimum value of the port";
    private static final String MAX_NAME = "max";
    private static final String MAX_DESCRIPTION = "Maximum value of the port";
    private static final String TEST_NAME = "test";
    private static final String TEST_DESCRIPTION = "The MUnit test flow";
    private static final String BEFORE_TEST_NAME = "before-test";
    private static final String BEFORE_TEST_DESCRIPTION = "Flow to be run before each MUnit test, one time per each test";
    private static final String AFTER_TEST_NAME = "after-test";
    private static final String AFTER_TEST_DESCRIPTION = "Flow to be run after each MUnit test, one time per each test";
    private static final String BEFORE_SUITE_NAME = "before-suite";
    private static final String BEFORE_SUITE_DESCRIPTION = "Flow to be run before any other in a MUnit suite, just one time";
    private static final String AFTER_SUITE_NAME = "after-suite";
    private static final String AFTER_SUITE_DESCRIPTION = "Flow to be run after any other in a MUnit suite, just one time";
    private static final String DESCRIPTION_NAME = "description";
    private static final String DESCRIPTION_DESCRIPTION = "Description message to be shown in case of test failure.";
    private static final String IGNORE_NAME = "ignore";
    private static final String IGNORE_DESCRIPTION = "Defines if the test must be ignored.";
    private static final String TAGS_NAME = "tags";
    private static final String TAGS_DESCRIPTION = "Defines the tags for the test.";
    private static final String TIMEOUT_NAME = "timeOut";
    private static final String TIMEOUT_DESCRIPTION = "Defines the maximum running time -in milliseconds- for the test.";
    private static final String EXPECTED_ERROR_TYPE_NAME = "expectedErrorType";
    private static final String EXPECTED_ERROR_TYPE_DESCRIPTION = "Error ID expected on this test.";
    private static final String EXPECTED_EXCEPTION_NAME = "expectedException";
    private static final String EXPECTED_EXCEPTION_DESCRIPTION = "Error expected on this test.";
    private static final String EXPECTED_ERROR_DESCRIPTION_NAME = "expectedErrorDescription";
    private static final String EXPECTED_ERROR_DESCRIPTION_DESCRIPTION = "Error description expected on this test.";
    private static final String ENABLE_FLOW_SOURCES_NAME = "enableFlowSources";
    private static final String ENABLE_FLOW_SOURCES_DESCRIPTION = "Flow sources to enable during the test";
    private static final String BEHAVIOR_NAME = "behavior";
    private static final String BEHAVIOR_DESCRIPTION = "Processors that define test behavior";
    private static final String EXECUTION_NAME = "execution";
    private static final String EXECUTION_DESCRIPTION = "Processors that define execution of the test";
    private static final String VALIDATION_NAME = "validation";
    private static final String VALIDATION_DESCRIPTION = "Processors that define validation of the test";
    private static final String SET_EVENT_NAME = "set-event";
    private static final String SET_EVENT_DESCRIPTION = "Defines the event to be used for testing";
    private static final String CLONE_ORIGINAL_EVENT_NAME = "cloneOriginalEvent";
    private static final String CLONE_ORIGINAL_EVENT_DESCRIPTION = "Define if the original Event should be cloned";
    private static final String PAYLOAD_NAME = "payload";
    private static final String PAYLOAD_DESCRIPTION = "The payload to be set.";
    private static final String ATTRIBUTES_NAME = "attributes";
    private static final String ATTRIBUTES_DESCRIPTION = "Attributes to be set.";
    private static final String ERROR_NAME = "error";
    private static final String ERROR_DESCRIPTION = "Error to be set.";
    private static final String VARIABLE_NAME = "variables";
    private static final String VARIABLE_DESCRIPTION = "Variables to be set.";
    private static final String INBOUND_PROPERTIES_NAME = "inbound-properties";
    private static final String INBOUND_PROPERTIES_DESCRIPTION = "Inbound properties to be set.";
    private static final String OUTBOUND_PROPERTIES_NAME = "outbound-properties";
    private static final String OUTBOUND_PROPERTIES_DESCRIPTION = "Outbound properties to be set.";
    private static final String SESSION_PROPERTIES_NAME = "session-properties";
    private static final String SESSION_PROPERTIES_DESCRIPTION = "Session properties to be set.";
    private static final String INBOUND_ATTACHMENTS_NAME = "inbound-attachments";
    private static final String INBOUND_ATTACHMENTS_DESCRIPTION = "Inbound attachments to be set.";
    private static final String OUTBOUND_ATTACHMENTS_NAME = "outbound-attachments";
    private static final String OUTBOUND_ATTACHMENTS_DESCRIPTION = "Outbound attachments to be set.";
    private static final String SET_NULL_PAYLOAD_NAME = "set-null-payload";
    private static final String SET_NULL_PAYLOAD_DESCRIPTION = "Defines a Null payload for testing";
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private final BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA);

    public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext extensionLoadingContext) {
        this.declareGeneral(extensionDeclarer);
        this.declareXmlDsl(extensionDeclarer);
        this.declareConfiguration(extensionDeclarer);
        this.declareOperations(extensionDeclarer);
        this.declareDynamicPort(extensionDeclarer);
    }

    private void declareGeneral(ExtensionDeclarer extensionDeclarer) {
        extensionDeclarer.named(NAME).describedAs(DESCRIPTION).onVersion("2.3.7").fromVendor(VENDOR).withCategory(Category.COMMUNITY);
    }

    private void declareXmlDsl(ExtensionDeclarer extensionDeclarer) {
        XmlDslModel xmlDslModel = XmlDslModel.builder().setPrefix(PREFIX).setNamespace(NAMESPACE).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("2.3.7").setXsdFileName(XSD_FILE_NAME).build();
        extensionDeclarer.withXmlDsl(xmlDslModel);
    }

    private void declareConfiguration(ExtensionDeclarer extensionDeclarer) {
        ConfigurationDeclarer configurationDeclarer = extensionDeclarer.withConfig(CONFIG_NAME).withStereotype(MuleStereotypes.CONFIG).describedAs(CONFIG_DESCRIPTION);
        ParameterGroupDeclarer parameterGroupDeclarer = configurationDeclarer.onDefaultParameterGroup();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(CONFIG_MIN_MULE_VERSION).describedAs(CONFIG_MIN_MULE_VERSION_DESCRIPTION)).ofType((MetadataType)this.typeBuilder.stringType().build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(CONFIG_REQUIRED_PRODUCT).describedAs(CONFIG_REQUIRED_PRODUCT_DESCRIPTION)).ofType((MetadataType)this.typeBuilder.stringType().build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("ignore").describedAs(CONFIG_IGNORE_DESCRIPTION)).ofType((MetadataType)this.typeBuilder.booleanType().build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        this.declareParameterizations(parameterGroupDeclarer);
    }

    private void declareParameterizations(ParameterGroupDeclarer parameterGroupDeclarer) {
        ObjectTypeBuilder parameterType = this.typeBuilder.objectType().with((TypeAnnotation)new TypeAliasAnnotation(PARAMETER_NAME)).with((TypeAnnotation)new TypeIdAnnotation(PARAMETER_CLASS_NAME)).with((TypeAnnotation)new TypeDslAnnotation(true, false, null, null));
        parameterType.addField().key("propertyName").value().stringType().with((TypeAnnotation)new LiteralTypeAnnotation());
        parameterType.addField().key(PARAMETERS_VALUE_FIELD).value().stringType().with((TypeAnnotation)new LiteralTypeAnnotation());
        ObjectTypeBuilder parameterizationType = this.typeBuilder.objectType().with((TypeAnnotation)new TypeAliasAnnotation(PARAMETERIZATION_NAME)).with((TypeAnnotation)new TypeIdAnnotation(PARAMETERIZATION_CLASS_NAME)).with((TypeAnnotation)new TypeDslAnnotation(true, false, null, null));
        parameterizationType.addField().key(PARAMETERIZATION_NAME_FIELD).required().value().stringType().with((TypeAnnotation)new LiteralTypeAnnotation());
        parameterizationType.addField().key(PARAMETERS_NAME).value((TypeBuilder)this.typeBuilder.arrayType().of((TypeBuilder)parameterType)).with((TypeAnnotation)new LiteralTypeAnnotation());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(PARAMETERIZATIONS_NAME).ofType((MetadataType)this.typeBuilder.arrayType().of((TypeBuilder)parameterizationType).build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build());
        ((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(PARAMETERIZATIONS_FILE).ofType((MetadataType)this.typeBuilder.stringType().build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private void declareDynamicPort(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer configuration = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct(DYNAMIC_PORT_NAME).allowingTopLevelDefinition().withStereotype(MuleStereotypes.APP_CONFIG)).describedAs(DYNAMIC_PORT_DESCRIPTION);
        configuration.onDefaultParameterGroup().withRequiredParameter("propertyName").ofType(this.typeLoader.load(String.class)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs(PROPERTY_NAME_DESCRIPTION);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter(MIN_NAME).ofType(this.typeLoader.load(Integer.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs(MIN_DESCRIPTION);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter(MAX_NAME).ofType(this.typeLoader.load(Integer.class))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs(MAX_DESCRIPTION);
    }

    private void declareOperations(ExtensionDeclarer extensionDeclarer) {
        this.declareMunitTestFlow(extensionDeclarer);
        this.declareMunitFlow(extensionDeclarer, BEFORE_TEST_NAME, BEFORE_TEST_DESCRIPTION, true);
        this.declareMunitFlow(extensionDeclarer, AFTER_TEST_NAME, AFTER_TEST_DESCRIPTION, true);
        this.declareMunitFlow(extensionDeclarer, BEFORE_SUITE_NAME, BEFORE_SUITE_DESCRIPTION, true);
        this.declareMunitFlow(extensionDeclarer, AFTER_SUITE_NAME, AFTER_SUITE_DESCRIPTION, true);
        this.declareSetEvent(extensionDeclarer);
        this.declareSetNullPayload(extensionDeclarer);
    }

    private void declareMunitTestFlow(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer testDeclarer = this.declareMunitFlow(extensionDeclarer, TEST_NAME, TEST_DESCRIPTION, false);
        ParameterGroupDeclarer parameterGroupDeclarer = testDeclarer.onDefaultParameterGroup();
        this.addOptionalParameter("ignore", IGNORE_DESCRIPTION, Boolean.class, parameterGroupDeclarer, null, ExpressionSupport.SUPPORTED);
        this.addOptionalParameter(TAGS_NAME, TAGS_DESCRIPTION, String.class, parameterGroupDeclarer, null, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalParameter(TIMEOUT_NAME, TIMEOUT_DESCRIPTION, Integer.class, parameterGroupDeclarer, null, ExpressionSupport.NOT_SUPPORTED);
        try {
            Class<?> forName = Class.forName("org.mule.runtime.extension.api.error.ErrorConstants");
            MetadataType errorTypeMatcherType = (MetadataType)forName.getDeclaredField("ERROR_TYPE_MATCHER").get(null);
            this.addOptionalParameter(EXPECTED_ERROR_TYPE_NAME, EXPECTED_ERROR_TYPE_DESCRIPTION, errorTypeMatcherType, parameterGroupDeclarer, null, ExpressionSupport.NOT_SUPPORTED);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            this.addOptionalParameter(EXPECTED_ERROR_TYPE_NAME, EXPECTED_ERROR_TYPE_DESCRIPTION, String.class, parameterGroupDeclarer, null, ExpressionSupport.NOT_SUPPORTED);
        }
        this.addOptionalParameter(EXPECTED_EXCEPTION_NAME, EXPECTED_EXCEPTION_DESCRIPTION, String.class, parameterGroupDeclarer, null, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalParameter(EXPECTED_ERROR_DESCRIPTION_NAME, EXPECTED_ERROR_DESCRIPTION_DESCRIPTION, String.class, parameterGroupDeclarer, null, ExpressionSupport.NOT_SUPPORTED);
        this.declareEnableFlowSources(parameterGroupDeclarer);
        this.declareMunitTestSection(BEHAVIOR_NAME, BEHAVIOR_DESCRIPTION, extensionDeclarer, testDeclarer);
        this.declareMunitTestSection(EXECUTION_NAME, EXECUTION_DESCRIPTION, extensionDeclarer, testDeclarer);
        this.declareMunitTestSection(VALIDATION_NAME, VALIDATION_DESCRIPTION, extensionDeclarer, testDeclarer);
    }

    private void declareEnableFlowSources(ParameterGroupDeclarer parameterGroupDeclarer) {
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(ENABLE_FLOW_SOURCES_NAME).describedAs(ENABLE_FLOW_SOURCES_DESCRIPTION)).ofType((MetadataType)this.typeBuilder.arrayType().of(this.typeLoader.load(EnableFlowSources.FlowRef.class)).build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private void declareMunitTestSection(String name, String description, ExtensionDeclarer extensionDeclarer, ConstructDeclarer testDeclarer) {
        StereotypeModel stereoType = StereotypeModelBuilder.newStereotype((String)name, (String)PREFIX).build();
        ConstructDeclarer munitTestSectionConstruct = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct(name).describedAs(description)).withStereotype(stereoType);
        this.overrideLocationPart((HasModelProperties)munitTestSectionConstruct);
        munitTestSectionConstruct.withChain();
        NestedComponentDeclarer munitTestSectionComponent = testDeclarer.withOptionalComponent(name).withAllowedStereotypes(new StereotypeModel[]{stereoType});
        this.overrideLocationPart((HasModelProperties)munitTestSectionComponent);
    }

    private void overrideLocationPart(HasModelProperties munitTestSectionComponent) {
        try {
            Class<?> forName = Class.forName("org.mule.runtime.module.extension.api.loader.java.property.CustomLocationPartModelProperty");
            munitTestSectionComponent.withModelProperty((ModelProperty)forName.getConstructor(String.class).newInstance("route"));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private ConstructDeclarer declareMunitFlow(ExtensionDeclarer extensionDeclarer, String name, String description, boolean singleton) {
        ConstructDeclarer constructDeclarer = ((ConstructDeclarer)extensionDeclarer.withConstruct(name).describedAs(description)).allowingTopLevelDefinition();
        ParameterDeclarer nameParam = constructDeclarer.onDefaultParameterGroup().withRequiredParameter(PARAMETERIZATION_NAME_FIELD).ofType(this.typeLoader.load(String.class)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        try {
            Method declaredMethod = ParameterDeclarer.class.getDeclaredMethod("asComponentId", new Class[0]);
            nameParam = (ParameterDeclarer)declaredMethod.invoke((Object)nameParam, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException declaredMethod) {
            // empty catch block
        }
        if (singleton) {
            try {
                Class<?> forName = Class.forName("org.mule.runtime.core.privileged.extension.SingletonModelProperty");
                constructDeclarer.withModelProperty((ModelProperty)forName.getConstructor(Boolean.TYPE).newInstance(true));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        this.addOptionalParameter(DESCRIPTION_NAME, DESCRIPTION_DESCRIPTION, String.class, constructDeclarer.onDefaultParameterGroup(), null, ExpressionSupport.NOT_SUPPORTED);
        return constructDeclarer;
    }

    private void declareSetEvent(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer operationDeclarer = (OperationDeclarer)extensionDeclarer.withOperation(SET_EVENT_NAME).describedAs(SET_EVENT_DESCRIPTION);
        operationDeclarer.withOutputAttributes().ofType(this.typeLoader.load(Object.class));
        operationDeclarer.withOutput().ofType((MetadataType)this.typeBuilder.anyType().build());
        ParameterGroupDeclarer declarer = operationDeclarer.onDefaultParameterGroup();
        this.addOptionalParameter(CLONE_ORIGINAL_EVENT_NAME, CLONE_ORIGINAL_EVENT_DESCRIPTION, Boolean.class, declarer, (Object)false, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalParameter(PAYLOAD_NAME, PAYLOAD_DESCRIPTION, Payload.class, declarer, null, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalParameter(ATTRIBUTES_NAME, ATTRIBUTES_DESCRIPTION, EventAttributes.class, declarer, null, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalParameter(ERROR_NAME, ERROR_DESCRIPTION, UntypedEventError.class, declarer, null, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalListParameter(VARIABLE_NAME, VARIABLE_DESCRIPTION, Variable.class, declarer, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalListParameter(INBOUND_PROPERTIES_NAME, INBOUND_PROPERTIES_DESCRIPTION, SetEventProcessor.InboundProperty.class, declarer, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalListParameter(OUTBOUND_PROPERTIES_NAME, OUTBOUND_PROPERTIES_DESCRIPTION, SetEventProcessor.OutboundProperty.class, declarer, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalListParameter(SESSION_PROPERTIES_NAME, SESSION_PROPERTIES_DESCRIPTION, SetEventProcessor.SessionProperty.class, declarer, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalListParameter(INBOUND_ATTACHMENTS_NAME, INBOUND_ATTACHMENTS_DESCRIPTION, SetEventProcessor.InboundAttachment.class, declarer, ExpressionSupport.NOT_SUPPORTED);
        this.addOptionalListParameter(OUTBOUND_ATTACHMENTS_NAME, OUTBOUND_ATTACHMENTS_DESCRIPTION, SetEventProcessor.OutboundAttachment.class, declarer, ExpressionSupport.NOT_SUPPORTED);
    }

    private void declareSetNullPayload(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer operationDeclarer = (OperationDeclarer)extensionDeclarer.withOperation(SET_NULL_PAYLOAD_NAME).describedAs(SET_NULL_PAYLOAD_DESCRIPTION);
        operationDeclarer.withOutputAttributes().ofType(this.typeLoader.load(Object.class));
        operationDeclarer.withOutput().ofType((MetadataType)this.typeBuilder.anyType().build());
    }

    private OptionalParameterDeclarer addOptionalParameter(String name, String description, Class<?> clazz, ParameterGroupDeclarer declarer, Object defaultValue, ExpressionSupport expressionSupport) {
        return this.addOptionalParameter(name, description, this.typeLoader.load(clazz), declarer, defaultValue, expressionSupport);
    }

    private OptionalParameterDeclarer addOptionalListParameter(String name, String description, Class<?> clazz, ParameterGroupDeclarer declarer, ExpressionSupport expressionSupport) {
        return this.addOptionalParameter(name, description, (MetadataType)this.typeBuilder.arrayType().of(this.typeLoader.load(clazz)).build(), declarer, null, expressionSupport);
    }

    private OptionalParameterDeclarer addOptionalParameter(String name, String description, MetadataType type, ParameterGroupDeclarer declarer, Object defaultValue, ExpressionSupport expressionSupport) {
        return (OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)declarer.withOptionalParameter(name).defaultingTo(defaultValue).describedAs(description)).ofType(type)).withExpressionSupport(expressionSupport)).withDsl(ParameterDslConfiguration.builder().allowsReferences(false).build());
    }
}

