/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.functions;

import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.meta.MuleVersion;

/**
 * {@link ExpressionFunction} that checks if the current mule version is prior to the provided one
 *
 * @since 2.2.0
 * @author Mulesoft Inc.
 */
public class MuleVersionPriorToFunction extends AbstractMuleVersionFunction {

  @Override
  protected boolean compare(MuleVersion muleVersion, MuleVersion currentMuleVersion) {
    return currentMuleVersion.priorTo(muleVersion);
  }
}
