/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.processors;

import org.mule.munit.common.event.EventBuilder;
import org.mule.runtime.core.api.event.CoreEvent;

/**
 * <p>
 * Sets the payload as null
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class SetNullPayloadProcessor extends MunitProcessor {

  @Override
  protected CoreEvent doProcess(CoreEvent event) {
    return (CoreEvent) new EventBuilder(event.getContext()).withPayload(null).build();
  }

  @Override
  protected String getProcessor() {
    return "SetNull";
  }
}
