/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.processors;

import java.util.List;

/**
 * Parameterization configuration of the test
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class Parameters {


  private List<Parameter> parameters;

  public List<Parameter> getParameters() {
    return parameters;
  }

  public void setParameters(List<Parameter> parameters) {
    this.parameters = parameters;
  }

  /**
   * Parameter model
   *
   * @author MuleSoft Inc.
   * @since 2.2.0
   */
  public static class Parameter {

    private String propertyName;
    private String value;

    public String getPropertyName() {
      return propertyName;
    }

    public String getValue() {
      return value;
    }

    public void setPropertyName(String propertyName) {
      this.propertyName = propertyName;
    }

    public void setValue(String value) {
      this.value = value;
    }
  }

}
