/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.config;

import static org.mule.munit.runner.config.MunitComponentBuildingDefinitionProvider.TEST;
import static org.mule.munit.runner.config.MunitXmlNamespaceInfoProvider.NAME_SPACE;

import org.mule.munit.runner.component.TestComponentInfoProvider;
import org.mule.runtime.api.component.ComponentIdentifier;

/**
 * {@link TestComponentInfoProvider} for the munit:test
 *
 * @since 2.2.0
 * @author Mulesoft Inc.
 */
public class RunnerTestComponentInfoProvider implements TestComponentInfoProvider {

  private static final ComponentIdentifier RUNNER_TEST_IDENTIFIER =
      ComponentIdentifier.builder().namespace(NAME_SPACE).name(TEST).build();

  @Override
  public ComponentIdentifier getComponentIdentifier() {
    return RUNNER_TEST_IDENTIFIER;
  }
}
